require 'rubygems'
require 'selenium-webdriver'

class Accordion
  require_relative "../module/DriverUtility"
  include DriverUtility

  def initialize(driver)
    @driver = driver
  end

  def clickSaveChangesBtn()
    click(:css,  'button[title="Save Changes"]')
  end

  def clickSaveBtnJump()
    waitForPageToFinishLoading
    @driver.execute_script("$(\"button[title='Save']\")[0].scrollIntoView(true)")
    click(:css, "button[title='Save']")
    @driver.execute_script("$('.container-fluid').css('overflow', 'visible');")
    @driver.execute_script("$('.container-fluid').css('overflow', 'inherit');")
    @driver.execute_script("$('.container-fluid').css('overflow', 'visible');")
    @driver.execute_script("$('.container-fluid').css('overflow', 'inherit');")
    @driver.execute_script("$('.container-fluid').css('overflow', 'visible');")
    @driver.execute_script("$('.container-fluid').css('overflow', 'visible');")
    @driver.execute_script("$('.container-fluid').css('overflow', 'inherit');")
    @driver.execute_script("$('.container-fluid').css('overflow', 'visible');")
    @driver.execute_script("$('.container-fluid').css('overflow', 'inherit');")
    @driver.execute_script("$('.container-fluid').css('overflow', 'visible');")
    waitForPageToFinishLoading
  end

  def clickSaveBtn()
    click(:css, "button[title='Save']")
  end

  def clickAccordionByHeading(heading)
    click(:css, 'div[heading="' + heading + '"] a.accordion-toggle')
  end

  def collapseAccordionByHeading(heading)
    click(:css, 'div[heading="' + heading + '"] i.icon-accordion-active')
  end

  def getCollapsedAccordionLabelByHeading(heading)
    labelText = getTextForElement(:css, 'div[heading="' + heading + '"] div.panel-heading h4 a')

    label = labelText.split("Expand\n")
    return label[1]

  end

  def verifyEmbeddedPDF()
    urlLink = @driver.current_url

    return urlLink.include?('pdf')
  end

  def isSaveButtonDisabled()
    element = getElement(:css, 'button[title="Save"]')
    disabled = element.attribute("disabled")

    if(disabled != nil and disabled == "true")
      return true
    else
      return false
    end

  end

  def isSaveChangesDisabled()
    element = getElement(:css, 'button[title="Save Changes"]')
    disabled = element.attribute("disabled")

    puts "Disabled is = " + disabled.to_s

    if(disabled != nil and disabled == "true")
      return true
    else
      return false
    end

  end

  def isAccordionCollapsed(heading)
    labelText = getTextForElement(:css, 'div[heading="' + heading + '"] div.panel-heading h4 a')

    if(labelText.include?("Expand"))
      return true
    else
      false
    end
  end

  def isRightArrowIconDisplayed(heading)
    element = getElement(:css, 'div[heading="' + heading + '"] div.panel-heading a i.myicon')
    classValue = element.attribute("class")

    if (classValue.include?("icon-accordion-static"))
      return true
    else
      return false
    end

  end

  def isDownArrowIconDisplayed(heading)
    element = getElement(:css, 'div[heading="' + heading + '"] div.panel-heading a i.myicon')
    classValue = element.attribute("class")

    if (classValue.include?("icon-accordion-active"))
      return true
    else
      return false
    end

  end

  def getAccordionAltText(heading)
    return getTextForElement(:css, 'div[heading="' + heading + '"] div.panel-heading h4 a')
  end

  def getAccordionLabelByHeading(heading)
    labelText = getTextForElement(:css, 'div[heading="' + heading + '"] div.panel-heading h4.accordion-panel-title')

    label = []

    if (labelText.include?("Collapse\n"))
      label = labelText.split("Collapse\n")
    elsif (labelText.include?("Expand\n"))
      label = labelText.split("Expand\n")
    end

    return label[1]
  end

  def getAccordionInfoTextByHeading(heading)
    return getTextForElement(:css,  'div[heading="' + heading + '"] div.panel-body div p.ng-binding ')
  end

  def getNthAccordionName(number)
    return getTextForElement(:css, "form[name='assessmentForm'] div div:nth-child(" + number.to_s + ") h4 a")
  end

end