
                                                   AUTOMATION README FILE

######This document has been created to help any automation tester working with this Ruby-Selenium Framework

#####Preconditions:
>User: This suite can be run using any veteran user

>Browser: Firefox version 45.0

>Selenium-webdriver: v2.53.4

>Environment: Currently automation is only run on the local environment

>Device: 15-inch MacBook Pro with the resolution set to 1920 x 1200

#####The following components and features and combinations of components and features will be tested:
Landing Page login

Home/GUI

My Profile

- My Contact Information
- Military/Occupational History

My Story

- Summary
- Personal Values
- Assessment-
- Reflections
- Goals
- Learn

My Medical

- Plan Your Appointment
- Symptom Dairy
- Medications
- Allergies
- Diagnoses
- Surgeries
- Hospitalizations
- Family History

Personal Trackers

- Blood Pressure and Pulse
- Cholesterol/Lipid
- Daily Events
- Diet
- Exercise
- Glucose (Self Tested)
- Height
- Mood
- Pain
- Respiration
- Sleep
- Stress
- Temperature
- Weight

My Reminders

- Appointments
- Medications
- Preventive Services
- Other

Notifications

- All Notifications
- MyVA Health Journal App Notices
- VA Health Messages

Contacts

- Healthcare Contacts
- Insurance Contacts
- Personal Contacts
- Communication Log

Assessments

- Health Status Self-Assessment
- Hospital Admission Care Assessment
- Outpatient Care Assessment

Images and Documents

- All
- Medical
- Military
- Other

Health Report

User Menu
- About
- Help
- Resources
- Take a Tour

Launchpad

Logout




#####Test Objective:
>To test and automate MyVA Health Journal the tester will need to enter, view, and track personal health information and
>cover 100% test coverage of all development work.



#####The automation tester will need to test:
>   - Track personal health information, including vital signs, diet, exercise, and daily events
>   - Enter your medical history information, including your medications, allergies, diagnoses, hospitalizations,
       surgeries, pregnancies, and family history
>   - Create and manage appointment, medication, and preventive service reminders
>   - View notifications received from your VA care team
>   - Reflect on what matters to you in your life and how your health can help you to reach your life goals
>   - Create and manage health care-related and personal contacts and related communications
>   - Complete health assessments
>   - Create a Health Report that includes data you have entered and tracked
>   - Share elements of your health information with your care team




#####Gemfile:
> All the dependent gems needed to run tests in this framework are listed in the Gemfile. The gem versions
> specified in the Gemfile should not be changed. Changing the gem version can cause deprecation issues to the
> framework



#####Database Configuration:
> This framework is using MongoDB and OracleDB on the back-end. OracleDB has no external configuration needed
> to run. Methods for OracleDB can be found in the Oracle.rb file within the module directory. MongoDB does require
> some external configuration to run. Gem ruby-oci8 is used for MongoDB to run, but will not work without
> installing some dependencies. To configure these dependencies, follow the steps specified in this
> link: http://www.rubydoc.info/gems/ruby-oci8/file/docs/install-on-osx.md. If these dependencies are not added, the
> MongoDB portion of this framework will not work.                                                                                                                                                                                                                             ##
> The Gems in the Gemfile and the dependencies in the link above are all you need to run the Selenium-Ruby
> framework.



#####Reports:
> The allure-regression-directory in the acceptance_test directory shows the last regression run report for this app and
> can be viewed by opening the html.index file inside the Allure_Regression directory on firefox browser version 45.

> The Allure-Report configuration can be found in the rspec_helper.rb file under the spec directory. Once an automation
> script is run, Allure will generate a directory which consists of .xml files. To convert these files into an html doc
> that can be used for reporting, a command line tool needs to be configured externally. To configure the Allure command
> line tool, follow the steps specified in this link: http://wiki.qatools.ru/display/AL/Allure+Commandline. Once the
> command line tool is configured, run this command "allure generate" and the path to the directory. This will create a
> separate directory in the framework similar to the allure-regression-report directory currently found under the
> acceptance test directory.

#####Run tests:
> All test scripts to run are found in the spec directory. To run specs, open any file under the spec directory and click
> on the run. Run button location will be different depending on the Integrated Development Environment used to work
> on this framework.

> Run the below commands from the command line to run specific tags depending on what you want to run. RSpec "it"
> blocks, "describe" blocks, and "context" blocks can be tagged and run separately depending on the circumstances.
> Currently this framework is using :broken, :bug, :regression, :acceptance, :smoketest. These tags can also be
> controlled from the rspec_helper.rb file. Any tag in the rspec_helper.rb file set to true will not run. Any tag in
> the rspec_helper.rb file set to false will run.

> For running all the tags run ```rspec --tag regression --tag acceptance --tag broken --tag smoketest $1 --format documentation```

> For running smoketest tags run ```rspec --tag smoketest spec/. --format documentation```

> For running acceptance and smoketest tags run ```rspec --tag acceptance --tag smoketest spec/. --format documentation```

> For running acceptance, regression and smoketest tags run ```rspec --tag acceptance --tag regression --tag smoketest spec/. --format nested```

> For running broken tags run ```rspec --tag broken spec/ --format documentation```

> For running acceptance tags run ```rspec --tag acceptance spec/. --format documentation```



#####Tests not run:
>RSpec "it" blocks with the tag :broken need to be worked on; the rest of the "it" blocks are working correctly.
>All gems, modules, classes and all instances of objects for all classes can be found in the globalized.rb file.
>Add and require the globalized.rb file to all test scripts created in the future to access all gems, modules, and
>classes in this framework that are used to write test scripts.



#####Updated selenium framework:
> The updated selenium framework can be found and cloned by going to this stash
> link: https://URL/projects/HA/repos/my-va-health-web/browse?at=refs%2Fheads%2FRelease-3.0.2-Branch
> The framework for automation will be found under the acceptance_test directory


#####Code changes:
> Most recent code changes and commits to this framework can be found in the Feature/Automated Regression Fixes Branch.















