/* VETERAN LOGIN */

var $username = $('#name-c'),
	$password = $('#password'),
	$error = $('.error');

$(document).on("pageinit", ".veteran-login", function(){
	"use strict";
	m.resources = new m.Resources();
	m.resources.fetch({async: false, url: "../../MobileHealthPlatformWeb/rest/public/resource-directory"});

	var clearErrors = function () {
			$error.text('');
		},
		showErrorMessage = function (text) {
			$error.text(text);
		},
		clearInputs = function () {
			$username.add($password).val("");
		},
		validateForm = function () {
			var emptyFields = [];

			clearErrors();
			// have to use attr for IE9 support.
			if (!$username.val().trim().length) {
				emptyFields.push($username.attr('placeholder'));
			}
			if (!$password.val().trim().length) {
				emptyFields.push($password.attr('placeholder'));
			}

			if(!emptyFields.length){
				return true;
			}

			showErrorMessage('Please enter ' + emptyFields.join(' and '));
			return false;
		};

	$('#resetLogin').on('click', function(){
		clearErrors();
		clearInputs();
	});

	$('#logonForm')
		.on('submit', validateForm)
		.on('keyup', 'input', function(e) {
			var $this = $(e.currentTarget),
				empty = $this.val().length;

			$this[empty ? 'removeClass' : 'addClass']('empty');
		});
});

$(document).on("ready", function(){
	$username.focus();
});
