define(
    ['Resources', 'Global'],
    function (resources, Global) {
        var User = Backbone.Model.extend({
            defaults: {
                "id": "",
                "lastName": "",
                "firstName": "",
                "displayName": "",
                "rightOfAccessAccepted": false,
                "link": "",
                "vistaLocation": "",
                "facilityName": ""
            },
            initialize: function () {
                this.url = resources.get('mhpuser').get('href');
                this.fetch({async: false});
                Global.getUtilities().flattenLinks(this);

                if (!this.id && !(typeof this.length !== 'undefined' && this.length >= 0)) {
                    window.location = Global.getUtilities().getReferencePath() + '../oauthlogin?redirect_uri=' + Global.getUtilities().getReferencePathWithHash();
                }
            }
        });
        return new User();
    }
);