/* Author: Benjamin Cushing

*/
(function( $ ){
	var methods = {
		init 	: function( options ) { 
			//Set the default values, use comma to separate the settings, example:
			var defaults = {
			//*** Need to set global variables *** ///
			}
			var options = $.extend(defaults, options);
			return this.each(function() {
			//console.log(o.callback);
			});
		},
	
		getHTML	: function( options, callbackFn ) {
			//Set the default values, use comma to separate the settings, example:
			var defaults = {
				url			: '',
				container	: '#main',
				dataType	: 'html',
				add			: 'html'
			}
			var options = $.extend(defaults, options);
			return this.each(function() {
				
				var o = options;
				$('#detail-findings').prepend('<img class="loading" src="../img/ajax-loader.gif"/>');

				$.ajax({
					type		: 'GET',
					url			: o.url,
					dataType	: o.dataType,
					success: function(data) {
						if (o.add == 'append'){
							$(o.container).append(data);
						} else {
							$(o.container).html(data);
						}
						$('#detail-findings .loading').remove();
						if ($.isFunction(callbackFn))
							callbackFn.call();
					}
				});
			});
		},
		postObject	: function( options, callbackFn) {
			//Set the default values, use comma to separate the settings, example:
			var defaults = {
				url			: '',
				contentType	:	'application/json', 
				dataType	:	'json',
				object		: ''
			}
			var options = $.extend(defaults, options);
			return this.each(function() {
				var o = options;
				$.ajax({
					type		: 'POST',
					url			: o.url,
					data		: o.object,
					dataType	: o.dataType,
					contentType	:	o.contentType,
					success: function(data) {
						if ($.isFunction(callbackFn))
							callbackFn.call();
					}
				});
			});
		},

		
		getUser	: function( options, loginCallbackFn, logoutCallbackFn) {
			//Set the default values, use comma to separate the settings, example:
			var defaults = {
				url			: '',
				container	:	'#user',
				dataType	:	'json'
			}
			var options = $.extend(defaults, options);
			return this.each(function() {
				var o = options;
				$.ajax({
					type		: 'GET',
					url			: o.url,
					dataType	: o.dataType,
					statusCode: {
						404: function() { },
						200: function(data) {
							
							if (data.mhpuser) {
								$(o.container).html('<span>Welcome, <span>' + data.mhpuser['displayName'] + '</span></span>');
								$(o.container).attr('data-id', data.mhpuser['id']);
								
								if ($.isFunction(loginCallbackFn)) {
									loginCallbackFn.call();
								}
							} else {
								if ($.isFunction(logoutCallbackFn)) {
									logoutCallbackFn.call();
								}
							}
						}
					}
					
				});
			});
		},
	
		
		writeToSessionStorage	: function( options, callbackFn ) {
			//Set the default values, use comma to separate the settings, example:
			var defaults = {
				key			: 	'',
				value		:	'',
				error		:	''
			}
			var options = $.extend(defaults, options);
			return this.each(function() {
				var o = options;
				try {
					window.sessionStorage[o.key]=JSON.stringify(o.value);
				} catch (e) {
				/*
if (e == QUOTA_EXCEEDED_ERR) {
					alert('Quota exceeded!');
				}
*/
			}
			});
		},
		
		getCheckList	: function( options, callbackFn ) {
			//Set the default values, use comma to separate the settings, example:
			var defaults = {
				url				: '',
				container	:	'#main',
			}
			var options = $.extend(defaults, options);
			return this.each(function() {
				var o = options;
				$.ajax({
					type		: 'GET',
					url			: o.url,
					dataType	: 'json',
					success: function(data) {
						if (o.app == 'share') {
							var size = data.size,
								list = {};
								listContent = '';
								detailsContent = '';
							for (var i=0; i<size; i++) {
								list.name	=	data.shareDomain[i].title;
								list.url	=	data.shareDomain[i].url;
								var formattedName = list.name.replace( new RegExp(" ", 'g'), "-" );
								listContent += '<li><label for="btn-' + formattedName + '">'+ list.name + '</label><input type="checkbox" id="btn-' + formattedName + '" value=' + formattedName + ' data-url="' + list.url + '" /><div class="listing-bg"></div></li>';
								
								detailsContent += '<section id="' + formattedName + '" class="expander"></section> ';
							}
							$(o.container).html(listContent);
							$('#details .detail-findings').append(detailsContent);
						}
						
						if (o.app == 'clinic-events') {
										
							var list = {};
							var listContent = '<li><h3 class="head">Past Appointments</h3><span class="arrow arrow-right"></span><ul class="results" style="display: none">';
							var size1 = data['Past-Appointments'].length;
							for (var i=0; i<size1; i++) {
								list.clinic		=	data['Past-Appointments'][i]['@clinicName'];
								list.facility	=	data['Past-Appointments'][i]['@facilityName'];
								list.startDate	=	data['Past-Appointments'][i]['@appointmentStartDate'].split(' ');
									
								list.mock		=	data['Past-Appointments'][i]['dataIdentifier']['@systemId'];
								list.id			=	data['Past-Appointments'][i]['dataIdentifier']['@uniqueId'];			
								list.patientId	=	data['Past-Appointments'][i]['patientIdentifier']['@uniqueId'];						
								listContent += '<li data-url=content/appointments/system/' + list.mock + '/id/' + list.id + '><h5>' + list.clinic + ', ' + list.facility + '</h3><span>' + list.startDate[0] + '</span><div class="listing-bg"></div></li>';
								 
							}
							listContent += '</ul></li><li><h3 class="head">Hospitalizations</h3><span class="arrow arrow-right"></span><ul class="results" style="display: none">';
							var size2 = data['Hospitalizations'].length;
							for (var i=0; i<size2; i++) {
								list.facility	=	data['Hospitalizations'][i]['@facilityName'];
								list.startDate	=	data['Hospitalizations'][i]['@admissionDate'].split(' ');
								list.endDate	=	data['Hospitalizations'][i]['@dischargeDate'].split(' ');		
								list.mock		=	data['Hospitalizations'][i]['dataIdentifier']['@systemId'];	
								list.id			=	data['Hospitalizations'][i]['dataIdentifier']['@uniqueId'];			
								list.patientId	=	data['Past-Appointments'][i]['patientIdentifier']['@uniqueId'];					
								listContent += '<li data-url=content/admissions/system/' + list.mock + '/id/' + list.id + '><h5>' + list.clinic + ', ' + list.facility + '</h3><span>' + list.startDate[0] + '</span><div class="listing-bg"></div></li>';
							}
							listContent += '</ul></li>';
							$(o.container).html(listContent);
						}
						if ($.isFunction(callbackFn)) {
							callbackFn.call();
						}
					}
				});
				
			});
			
		},
	}		
	$.fn.core = function( method ) {
		// Method calling logic
		if ( methods[method] ) {
			return methods[ method ].apply( this, Array.prototype.slice.call( arguments, 1 ));
		} else if ( typeof method === 'object' || ! method ) {
			return methods.init.apply( this, arguments );
		} else {
			$.error( 'Method ' + method + ' does not exist on jQuery.tooltip' );
		}
	};
})( jQuery );
		
