<!doctype html>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="spring" uri="http://www.springframework.org/tags" %>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form" %>

<html lang="en" class="no-js">
    <head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="description" content="">
    <meta name="author" content="">
    <meta name="viewport" content="width=device-width,initial-scale=1, minimum-scale=1, maximum-scale=2">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="black">

    <title>Department of Veterans Affairs - Veteran Login Page</title>

    <link rel="stylesheet" href="<c:url value="/css/jquery.mobile-1.3.0.min.css"/>">
    <link rel="stylesheet" href="<c:url value="/css/login/new-login.css"/>">

    <script src="<c:url value="/js/libs/jquery-1.9.1.min.js"/>"></script>
    <script src="<c:url value="/js/utilities.js"/>"></script>
    <script src="<c:url value="/js/libs/modernizr.custom.js"/>"></script>
    <script src="<c:url value="/js/loginBrowserSniffer.js"/>"></script>
    <script src="<c:url value="/js/libs/jquery.mobile-1.3.0.min.js"/>"></script>

    <script src="<c:url value="/js/libs/underscore.js"/>"></script>
    <script src="<c:url value="/js/libs/backbone.js"/>"></script>
    <script src="<c:url value="/js/models.js"/>"></script>

    </head>

    <body>
        <div data-role="page" class="veteran-login">
            <div class="heading">
                <header>
                    <h1>Department of Veterans Affairs</h1>
                    <h2>Veteran Login</h2>
                </header>
                <img src="<c:url value="/img/logo_navbar_ipad.png"/>" id="logo" alt="VA Login"/>
            </div>
            <div>
                <div class="error" title="error-message"><c:if test="${not empty error}">${error}</c:if></div>
                <form id="logonForm" name="logonForm" data-ajax="false" method="post" action="<c:url value="/j_spring_security_check"/>">
                    <input data-role="none" required placeholder="Username" spellcheck="false" id="name-c" type="text" autocorrect="off"
                        autocapitalize="off" autocomplete="off" name="j_username" value="" class="empty ui-input-text ui-body-null
                        ui-corner-all ui-shadow-inset ui-body-c" />
                    <label class="hide508" for="name-c">Username</label>

                    <input data-role="none" required placeholder="Password" id="password" type="password" autocomplete="off" name="j_password" value=""
                        class="empty ui-input-text ui-body-null ui-corner-all ui-shadow-inset ui-body-c" />
                    <label class="hide508" for="password">Password</label>

                    <button type="button" data-inline="true" id="resetLogin">Clear</button>
                    <button data-inline="true" id="loginButton">Sign In</button>
                </form>
            </div>
        </div>
        <script src="<c:url value="/js/libs/jquery.placeholder.polyfill.js"/>"></script>
        <script src="<c:url value="/js/veteran-login.js"/>"></script>
    </body>
</html>
