package com.agilex.healthcare.mobilehealthplatform.web;

import javax.servlet.http.HttpServletRequest;

import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class SSOELoginController{
	
	@RequestMapping(value = "/login", method = RequestMethod.GET)
	public ModelAndView displayLoginPage(@RequestParam(value = "error", required = false) boolean error,
			HttpServletRequest req, ModelMap model) {

		constructErrorMessageIfErrorExists(model, error);

		return new ModelAndView("userLogin", model);
	}

	private void constructErrorMessageIfErrorExists(ModelMap model, boolean error) {
		if (error == true) {
			model.put("error", "Invalid Username or Password!");
		} else {
			model.put("error", "");
		}
	}
	
	@RequestMapping(value = "/denied", method = RequestMethod.GET)
	public ModelAndView getLoginPage(HttpServletRequest req, ModelMap model) {

		model.put("error", "Invalid Username or Password!");

		return new ModelAndView("userLogin", model);
	}

}
