package com.agilex.healthcare.mobilehealthplatform.security;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import com.agilex.healthcare.mobilehealthplatform.domain.DOBDate;
import com.agilex.healthcare.mobilehealthplatform.domain.MhpUser;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.utility.DateHelper;
import com.agilex.healthcare.utility.NullChecker;

public class SSOEUserRepository {
    //If you change this must make sure creation of map is thread safe
    private Map<String, MhpUser> getUsers(){
        Map<String, MhpUser> users = new HashMap<String, MhpUser>();
        
        addPatientUser(users, "zztest.patient01"			, "zztest patient01"				, "zztest"			, "patient01"		, "D123401"			, "05/05/1900"	, "MALE"	, "999999901"	);
        addPatientUser(users, "zztest.patient02a"			, "zztest patient02"				, "zztest"			, "patient02"		, "PATID1"			, "10/05/1900"	, "MALE"	, "999999902"	);
        addPatientUser(users, "zztest.patient02b"			, "zztest patient02"				, "zztest"			, "patient02"		, "PATID2"			, "10/05/1900"	, "MALE"	, "999999903"	);
        addPatientUser(users, "zztest.patient04"			, "zztest patient04"				, "zztest"			, "patient04"		, "PATID3"			, "12/12/1900"	, "MALE"	, "999999904"	);
        addPatientUser(users, "zztest.patient05"			, "zztest patient05"				, "zztest"			, "patient05"		, "PATID4"			, "12/13/1900"	, "FEMALE"	, "999999905"	);
        addPatientUser(users, "zztest.patient06"			, "zztest patient06"				, "zztest"			, "patient06"		, "PATID5"			, "06/06/1900"	, "MALE"	, "999999906"	);
        addPatientUser(users, "zztest05.patient26"			, "zztest05 patient26"				, "zztest05"		, "patient26"		, "PATID6"			, "01/12/1900"	, "MALE"	, "999999907"	);
        addPatientUser(users, "zztest.patient08"			, "zztest patient08"				, "zztest"			, "patient08"		, "PATID7"			, "07/04/1900"	, "FEMALE"	, "999999908"	);
        addPatientUser(users, "zztest.patient09"			, "zztest patient09"				, "zztest"			, "patient09"		, "1099737332"			, "05/21/1900"	, "MALE"	, "999999909"	);
        addPatientUser(users, "zztest.patient10"			, "zztest patient10"				, "zztest"			, "patient10"		, "1098230730"			, "01/01/1900"	, ""		, "999999910"	);
        addPatientUser(users, "zztest.patient11"			, "zztest patient11"				, "zztest"			, "patient11"		, "1013599714"			, "01/01/1900"	, "FEMALE"	, "999999911"	);
        addPatientUser(users, "zztest.patient12"			, "zztest patient12"				, "zztest"			, "patient12"		, "PATID11"			, "02/15/1900"	, "MALE"	, "999999912"	);
        addPatientUser(users, "zztest.patient13"			, "zztest patient13"				, "zztest"			, "patient13"		, "PATID12"			, "01/01/1900"	, "MALE"	, "999999913"	);
        addPatientUser(users, "zztest.patient14"			, "zztest patient14"				, "zztest"			, "patient14"		, "PATID13"			, "03/10/1900"	, "FEMALE"	, "999999914"	);
        addPatientUser(users, "zztest.patient15"			, "zztest patient15"				, "zztest"			, "patient15"		, "PATID14"			, "04/04/1900"	, "MALE"	, "999999915"	);
        addPatientUser(users, "zztest.patient16"			, "zztest patient16"				, "zztest"			, "patient16"		, "PATID15"			, "02/02/1900"	, "FEMALE"	, "999999916"	);
        addPatientUser(users, "zztest.patient17"			, "zztest patient17"				, "zztest"			, "patient17"		, "PATID16"			, "05/05/1900"	, "MALE"	, "999999917"	);
        addPatientUser(users, "zztest.patient18"			, "zztest patient18"				, "zztest"			, "patient18"		, "PATID18"			, "09/04/1900"	, "MALE"	, "999999918"	);
        addPatientUser(users, "zztest.patient19"			, "zztest patient19"				, "zztest"			, "patient19"		, "PATID19"			, "02/02/1900"	, "MALE"	, "999999919"	);
        addPatientUser(users, "zztest.patient20"			, "zztest patient20"				, "zztest"			, "patient20"		, "PATID20"			, "06/06/1900"	, "MALE"	, "999999920"	);
        addPatientUser(users, "zztest.patient21"			, "zztest patient21"				, "zztest"			, "patient21"		, "PATID21"			, "01/01/1900"	, "MALE"	, "999999921"	);
        addPatientUser(users, "zztest01.patient26"			, "zztest01 patient26"				, "zztest01"		, "patient26"		, "PATID22"			, "10/06/1900"	, "FEMALE"	, "999999922"	);
        addPatientUser(users, "zztest02.patient26"			, "zztest02 patient26"				, "zztest02"		, "patient26"		, "PATID23"			, "11/06/1900"	, "MALE"	, "999999923"	);
        addPatientUser(users, "zztest03.patient26"			, "zztest03 patient26" 				, "zztest03"		, "patient26"		, "PATID24"			, "11/06/1900"	, "MALE"	, "999999924"	);
        addPatientUser(users, "zztest04.patient26"			, "zztest04 patient26"				, "zztest04"		, "patient26"		, "PATID25"			, "01/01/1900"	, ""		, "999999925"	);
        addPatientUser(users, "zztest.patient26"			, "zztest patient26"				, "zztest"          , "patient26"		, "PATID26"			, "3/23/1900"	, "MALE"	, "999999926"	);
        addPatientUser(users, "zztest06.patient26"			, "zztest06 patient26"				, "zztest06"		, "patient26"		, "PATID27"			, "11/09/1900"	, ""		, "999999927"	);
        addPatientUser(users, "zztest07.patient26"			, "zztest07 patient26"				, "zztest07"		, "patient26"		, "PATID28"			, "01/01/1900"	, "U"		, "999999928"	);
        addPatientUser(users, "zztest08.patient26"			, "zztest08 patient26"				, "zztest08"		, "patient26"		, "PATID29"			, "08/06/1900"	, "MALE"	, "999999929"	);
        addPatientUser(users, "zztest09.patient26"			, "zztest09 patient26"				, "zztest09"		, "patient26"		, "PATID30"			, "01/01/1900"	, "MALE"	, "999999930"	);
        addPatientUser(users, "zztest10.patient26"			, "zztest10 patient26"				, "zztest10"		, "patient26"		, "PATID31"			, "04/15/1900"	, "FEMALE"	, "999999931"	);
        addPatientUser(users, "zztest11.patient26"			, "zztest11 patient26"				, "zztest11"		, "patient26"		, "PATID32"			, "01/01/1900"	, "MALE"	, "999999932"	);
        addPatientUser(users, "zztest12.patient26"			, "zztest12 patient26"				, "zztest12"		, "patient26"		, "PATID33"			, "08/09/1900"	, "MALE"	, "999999933"	);
        addPatientUser(users, "zztest13.patient26"			, "zztest13 patient26"				, "zztest13"		, "patient26"		, "PATID34"			, "04/15/1900"	, "FEMALE"	, "999999934"	);
        addPatientUser(users, "zztest14.patient26"			, "zztest14 patient26"				, "zztest14"		, "patient26"		, "PATID35"			, "03/15/1900"	, "MALE"	, "999999935"	);
        addPatientUser(users, "zztest15.patient26"			, "zztest15 patient26"				, "zztest15"		, "patient26"		, "PATID36"			, "10/25/1900"	, "FEMALE"	, "999999936"	);
        addPatientUser(users, "zztest16.patient26"			, "zztest16 patient26"				, "zztest16"		, "patient26"		, "PATID37"			, "06/05/1900"	, "MALE"	, "999999937"	);
        addPatientUser(users, "zztest17.patient26"			, "zztest17 patient26"				, "zztest17"		, "patient26"		, "PATID38"			, "02/27/1900"	, "FEMALE"	, "999999938"	);
        addPatientUser(users, "zztest18.patient26"			, "zztest18 patient26"				, "zztest18"		, "patient26"		, "PATID39"			, "01/01/1900"	, "MALE"	, "999999939"	);
        addPatientUser(users, "zztest19.patient26"			, "zztest19 patient26"				, "zztest19"		, "patient26"		, "PATID40"			, "12/30/1900"	, "FEMALE"	, "999999940"	);
        addPatientUser(users, "zztest20.patient26"			, "zztest20 patient26"				, "zztest20"		, "patient26"		, "PATID41"			, "01/01/1900"	, "MALE"	, "999999941"	);
        addPatientUser(users, "zztest21.patient26"			, "zztest21 patient26"				, "zztest21"		, "patient26"		, "PATID42"			, "05/19/1900"	, "FEMALE"	, "999999942"	);
        addPatientUser(users, "zztest22.patient26"			, "zztest22 patient26"				, "zztest22"		, "patient26"		, "PATID43"			, "01/01/1900"	, "FEMALE"	, "999999943"	);
        addPatientUser(users, "zztest23.patient26"			, "zztest23 patient26"				, "zztest23"		, "patient26"		, "PATID44"			, "05/18/1900"	, "MALE"	, "999999944"	);
        addPatientUser(users, "zztest24.patient26"			, "zztest24 patient26"				, "zztest24"		, "patient26"		, "PATID45"			, "05/28/1900"	, "MALE"	, "999999945"	);
        addPatientUser(users, "zztest25.patient26"			, "zztest25 patient26"				, "zztest25"		, "patient26"		, "PATID46"			, "03/15/1900"	, "MALE"	, "999999946"	);
        addPatientUser(users, "zztest.patient47"			, "zztest patient47"				, "zztest"			, "patient47"		, "PATID47"			, "03/15/1900"	, "FEMALE"	, "999999947"	);
        addPatientUser(users, "zztest.patient48"			, "zztest patient48"				, "zztest"			, "patient48"		, "PATID48"			, "07/15/1900"	, "MALE"	, "999999948"	);
        addPatientUser(users, "zztest.patient49"			, "zztest patient49"				, "zztest"			, "patient49"		, "PATID49"			, "08/18/1900"	, "MALE"	, "999999949"	);
        addPatientUser(users, "zztest.patient50"			, "zztest patient50"				, "zztest"			, "patient50"		, "PATID50"			, "09/19/1900"	, "MALE"	, "999999950"	);
        addPatientUser(users, "zztest.patient51"			, "zztest patient51"				, "zztest"			, "patient51"		, "PATID51"			, "05/05/1900"	, "MALE"	, "999999951"	);
        addPatientUser(users, "zztest.patient52"			, "zztest patient52"				, "zztest"			, "patient52"		, "PATID52"			, "05/05/1900"	, "MALE"	, "999999952"	);
        addPatientUser(users, "zztest.patient53"			, "zztest patient53"				, "zztest"			, "patient53"		, "PATID53"			, "05/05/1900"	, "MALE"	, "999999953"	);
        addPatientUser(users, "zztest.patient54"			, "zztest patient54"				, "zztest"			, "patient54"		, "PATID54"			, "05/05/1900"	, "MALE"	, "999999954"	);
        addPatientUser(users, "zztest.patient55"			, "zztest patient55"				, "zztest"			, "patient55"		, "PATID55"			, "05/05/1900"	, "MALE"	, "999999955"	);
        addPatientUser(users, "zztest.patient56"			, "zztest patient56"				, "zztest"			, "patient56"		, "PATID56"			, "Feb 1900"	, ""		, "999999956"	);
        addPatientUser(users, "zztest.patient57"			, "zztest patient57"				, "zztest"			, "patient57"		, "PATID57"			, "1900"		, ""		, "999999957"	);
        addPatientUser(users, "zztest.patient58"			, "zztest patient58"				, "zztest"			, "patient58"		, "PATID58"			, "11/08/1900"	, "MALE"	, "999999958"	);
        addPatientUser(users, "zztest.patient59"			, "zztest patient59"				, "zztest"			, "patient59"		, "PATID59"			, "11/08/1900"	, "MALE"	, "999999959"	);
        addPatientUser(users, "zztest.patient60"			, "zztest patient60"				, "zztest"			, "patient60"		, "PATID60"			, "11/08/1900"	, "MALE"	, "999999960"	);
        addPatientUser(users, "zztest.patient61"			, "zztest patient61"				, "zztest"			, "patient61"		, "PATID61"			, "11/08/1900"	, "MALE"	, "999999961"	);
        addPatientUser(users, "zztest.patient62"			, "zztest patient62"				, "zztest"			, "patient62"		, "PATID62"			, "11/08/1900"	, "MALE"	, "999999962"	);
        addPatientUser(users, "zztest.patient63"			, "zztest patient63"				, "zztest"			, "patient63"		, "PATID63"			, "11/08/1900"	, "MALE"	, "999999963"	);
        addPatientUser(users, "zztest.patient64"			, "zztest patient64"				, "zztest"			, "patient64"		, "PATID64"			, "11/08/1900"	, "MALE"	, "999999964"	);
        
        addPatientUser(users, "Usability.TestPatient"		, "Usability Testpatient"			, "Usability"		, "Testpatient"		, "PATID65"			, "11/08/1900"	, "MALE"	, "XXXYYZZZZ"	);
        addPatientUser(users, "UsabilityTwo.TestPatient"	, "UsabilityTwo Testpatient"		, "UsabilityTwo"	, "Testpatient"		, "PATID66"			, "11/08/1900"	, "MALE"	, "988898989"	);
        addPatientUser(users, "UsabilityThree.TestPatient"	, "UsabilityThree Testpatient"		, "UsabilityThree"	, "Testpatient"		, "PATID67"			, "11/08/1900"	, "MALE"	, "988898989"	);
        addPatientUser(users, "UsabilityFour.TestPatient"	, "UsabilityFour Testpatient"		, "UsabilityFour"	, "Testpatient"		, "PATID68"			, "11/08/1900"	, "MALE"	, "988898989"	);
        addPatientUser(users, "UsabilityFive.TestPatient"	, "UsabilityFive Testpatient"		, "UsabilityFive"	, "Testpatient"		, "PATID69"			, "11/08/1900"	, "MALE"	, "988898989"	);
        addPatientUser(users, "UsabilitySix.TestPatient"	, "UsabilitySix Testpatient"		, "UsabilitySix"	, "Testpatient"		, "PATID70"			, "11/08/1900"	, "MALE"	, "988898989"	);
        addPatientUser(users, "UsabilitySeven.TestPatient"	, "UsabilitySeven Testpatient"		, "UsabilitySeven"	, "Testpatient"		, "PATID71"			, "11/08/1900"	, "MALE"	, "988898989"	);
        addPatientUser(users, "UsabilityEight.TestPatient"	, "UsabilityEight Testpatient"		, "UsabilityEight"	, "Testpatient"		, "PATID72"			, "11/08/1900"	, "MALE"	, "988898989"	);
        addPatientUser(users, "UsabilityNine.TestPatient"	, "UsabilityNine Testpatient"		, "UsabilityNine"	, "Testpatient"		, "PATID73"			, "11/08/1900"	, "MALE"	, "988898989"	);
        addPatientUser(users, "UsabilityTen.TestPatient"	, "UsabilityTen Testpatient"		, "UsabilityTen"	, "Testpatient"		, "PATID74"			, "11/08/1900"	, "MALE"	, "988898989"	);
        
        addPatientUser(users, "zztest.patient65"			, "zztest patient65"				, "zztest"			, "patient65"		, "PATID75"			, "01/01/1900"	, "MALE"	, "999999965"	);
        addPatientUser(users, "zztest.patient66"			, "zztest patient66"				, "zztest"			, "patient66"		, "PATID76"			, "01/01/1900"	, "MALE"	, "999999966"	);
        addPatientUser(users, "zztest.patient67"			, "zztest patient67"				, "zztest"			, "patient67"		, "PATID77"			, "01/01/1900"	, "MALE"	, "999999967"	);
        addPatientUser(users, "zztest.patient68"			, "zztest patient68"				, "zztest"			, "patient68"		, "PATID78"			, "01/01/1900"	, ""		, "999999968"	);
        addPatientUser(users, "zztest.patient'69"			, "zztest patient'69"				, "zztest"			, "patient'69"		, "PATID79"			, "08/02/1900"	, "MALE"	, "999999969"	);
        addPatientUser(users, "zztest.patient 70"			, "zztest patient 70"				, "zztest"			, "patient 70"		, "PATID80"			, "03/08/1900"	, "MALE"	, "999999970"	);
        addPatientUser(users, "zztest.patient-71"			, "zztest patient-71"				, "zztest"			, "patient-71"		, "PATID81"			, "01/13/1900"	, "MALE"	, "999999971"	);
        addPatientUser(users, "zztest.patient72"			, "zztest patient72"				, "zztest"			, "patient72"		, "pactUser"		, "1900"		, "MALE"	, "999999972"	);
        addPatientUser(users, "zztest.patient73"			, "zztest patient73"				, "zztest"			, "patient73"		, "COPY-123401"		, "05/05/1900"	, "MALE"	, "999999973"	);
        addPatientUser(users, "zztest.patient74"			, "zztest patient74"				, "zztest"			, "patient74"		, "8"				, "01/01/1900"	, "MALE"	, "999999974"	);
        
        addPatientUser(users, "ONE.VAMOBILEPATIENT"			, "ONE VAMOBILEPATIENT"				, "ONE"				, "VAMOBILEPATIENT"	, "0010010010"		, "01/01/1900"	, "MALE"	, "999999999"		);
        addPatientUser(users, "TWO.VAMOBILEPATIENT"			, "TWO VAMOBILEPATIENT"				, "TWO"				, "VAMOBILEPATIENT"	, "0010010011"		, "01/01/1900"	, "FEMALE"	, "999999999"		);
        addPatientUser(users, "THREE.VAMOBILEPATIENT"		, "THREE VAMOBILEPATIENT"			, "THREE"			, "VAMOBILEPATIENT"	, "0010010012"		, "01/01/1900"	, "MALE"	, "999999999"		);
        addPatientUser(users, "FOUR.VAMOBILEPATIENTVAMOBILEPATIENT"		, "FOUR VAMOBILEPATIENTVAMOBILEPATIENT"			, "FOUR"			, "VAMOBILEPATIENTVAMOBILEPATIENT"	, "0010010013"		, "01/01/1900"	, "MALE"	, "999999999"		);
        
        addPatientUser(users, "zztest.patient75"			, "zztest patient75"				, "zztest"			, "patient75"		, "INT-TEST-MOCK"	, "1900"		, "MALE"	, "999999975"	);
        addPatientUser(users, "zztest.patient76"			, "zztest patient76"				, "zztest"			, "patient76"		, "NO-DATA-MOCK"	, "1900"		, "MALE"	, "999999976"	);
        addPatientUser(users, "zztest.patient77"			, "zztest patient77"				, "zztest"			, "patient77"		, "PATID82"			, "03/12/1900"	, "MALE"	, "999999977"	);
        addPatientUser(users, "zztest.patient78"			, "zztest patient78"				, "zztest"			, "patient78"		, "PATID83"			, "03/11/1900"	, "MALE"	, "999999978"	);
        addPatientUser(users, "zztest.patient80"			, "zztest patient80"				, "zztest"			, "patient80"		, "PATID84"			, "01/11/1900"	, "MALE"	, "999999980"	);
        addPatientUser(users, "zztest.patient81"			, "zztest patient81"				, "zztest"			, "patient81"		, "PATID85"			, "02/10/1900"	, "MALE"	, "999999981"	);
        addPatientUser(users, "zztest.patient82"			, "zztest patient82"				, "zztest"			, "patient82"		, "PATID86"			, "01/09/1900"	, "MALE"	, "999999982"	);
        addPatientUser(users, "zztest.patient83"			, "zztest patient83"				, "zztest"			, "patient83"		, "PATID87"			, "01/10/1900"	, "MALE"	, "999999983"	);
        addPatientUser(users, "zztest.patient84"			, "zztest patient84"				, "zztest"			, "patient84"		, "PATID88"			, "01/05/1900"	, "MALE"	, "999999984"	);
        
        addPatientUser(users, "zztest.noidentifier"			, "zztest noidentifier"				, "zztest"			, "noidentifier"	, "noidentifier"	, "05/05/1980"	, "MALE"	, "000999901"	);
        addPatientUser(users, "zztest.nullIdentifier"		, "zztest nullIdentifier"			, "zztest"			, "nullIdentifier"	, null				, "05/05/1981"	, "MALE"	, "000999902"	);
        addPatientUser(users, "zztest.emptyIdentifier"		, "zztest emptyIdentifier"			, "zztest"			, "emptyIdentifier"	, ""				, "05/05/1982"	, "MALE"	, "000999903"	);
        addPatientUser(users, "zztest.NOTFOUND"				, "zztest NOTFOUND"					, "zztest"			, "NOTFOUND"		, "NOT_FOUND"		, "05/05/1983"	, "MALE"	, "000999904"	);
        
        addPatientUser(users, "PATIENT.ONE"			, "PATIENT ONE"				, "PATIENT"			, "ONE"		, "P001"			, "04/07/1935"	, "MALE"	, "666000001"	);
        addPatientUser(users, "PATIENT.TWO"			, "PATIENT TWO"				, "PATIENT"			, "TWO"		, "P002"			, "01/01/1900"	, "MALE"	, "666000002"	);
        addPatientUser(users, "PATIENT.THREE"		, "PATIENT THREE"			, "PATIENT"			, "THREE"	, "P003"			, "01/01/1900"	, "MALE"	, "666000003"	);
        addPatientUser(users, "PATIENT.FOUR"		, "PATIENT FOUR"			, "PATIENT"			, "FOUR"	, "P004"			, "01/01/1900"	, "MALE"	, "666000004"	);
        addPatientUser(users, "PATIENT.FIVE"		, "PATIENT FIVE"			, "PATIENT"			, "FIVE"	, "P005"			, "01/01/1900"	, "MALE"	, "666000005"	);
        addPatientUser(users, "PATIENT.SIX"			, "PATIENT SIX"				, "PATIENT"			, "SIX"		, "P006"			, "01/01/1900"	, "MALE"	, "666000006"	);
        addPatientUser(users, "PATIENT.SEVEN"		, "PATIENT SEVEN"			, "PATIENT"			, "SEVEN"	, "P007"			, "01/01/1900"	, "MALE"	, "666000007"	);
        addPatientUser(users, "PATIENT.EIGHT"		, "PATIENT EIGHT"			, "PATIENT"			, "EIGHT"	, "P008"			, "01/01/1900"	, "MALE"	, "666000008"	);
        addPatientUser(users, "PATIENT.NINE"		, "PATIENT NINE"			, "PATIENT"			, "NINE"	, "P009"			, "01/01/1900"	, "MALE"	, "666000009"	);
        addPatientUser(users, "PATIENT.TEN"			, "PATIENT TEN"				, "PATIENT"			, "TEN"		, "P010"			, "01/01/1900"	, "MALE"	, "666000010"	);
        addPatientUser(users, "PATIENT.ELEVEN"			, "PATIENT ELEVEN"				, "PATIENT"			, "ELEVEN"		, "P011"			, "01/01/1902"	, "MALE"	, "666000011"	);
        addPatientUser(users, "EIGHT.BCMA"			, "EIGHT BCMA"				, "EIGHT"			, "BCMA"	, "P012"			, "01/01/1900"	, "MALE"	, "666000012"	);
        addPatientUser(users, "EIGHTEEN-PATIENT.BCMA", "EIGHTEEN-PATIENT BCMA"	, "EIGHTEEN-PATIENT", "BCMA"	, "P013"			, "01/01/1900"	, "MALE"	, "666000013"	);
        addPatientUser(users, "ONE.GRAPHINGPATIENT" , "ONE GRAPHINGPATIENT"		, "ONE"			    , "GRAPHINGPATIENT"	   , "P014"	, "01/01/1900"	, "MALE"	, "666000014"	);
        addPatientUser(users, "NEW ONE.ALPHATEST"   , "NEW ONE ALPHATEST"	    , "NEW ONE"         , "ALPHATEST"	       , "P015"	, "01/01/1900"	, "MALE"	, "666000015"	);

        addPatientUser(users, "zztest.veteran01"	, "zztest veteran01"				, "zztest"			, "veteran01"		, "1244420300"			, "05/05/1951"	, "MALE"	, "699999901");
        addPatientUser(users, "zztest.veteran02"	, "zztest veteran02"				, "zztest"			, "veteran02"		, "1010198069"			, "05/05/1952"	, "MALE"	, "699999902");
        addPatientUser(users, "zztest.veteran03"	, "zztest veteran03"				, "zztest"			, "veteran03"		, "1100158376"			, "05/05/1953"	, "MALE"	, "699999903");
        addPatientUser(users, "zztest.veteran04"	, "zztest veteran04"				, "zztest"			, "veteran04"		, "1104345570"			, "05/05/1954"	, "MALE"	, "699999904");
        addPatientUser(users, "zztest.veteran05"	, "zztest veteran05"				, "zztest"			, "veteran05"		, "1284181731"			, "05/05/1955"	, "MALE"	, "699999905");
        addPatientUser(users, "zztest.veteran06"	, "zztest veteran06"				, "zztest"			, "veteran06"		, "1098683964"			, "05/05/1951"	, "MALE"	, "699999906");
        addPatientUser(users, "zztest.veteran07"	, "zztest veteran07"				, "zztest"			, "veteran07"		, "1015910263"			, "05/05/1952"	, "MALE"	, "699999907");
        addPatientUser(users, "zztest.veteran08"	, "zztest veteran08"				, "zztest"			, "veteran08"		, "1324323534"			, "05/05/1953"	, "MALE"	, "699999908");
        addPatientUser(users, "zztest.veteran09"	, "zztest veteran09"				, "zztest"			, "veteran09"		, "1021206853"			, "05/05/1954"	, "MALE"	, "699999909");
        addPatientUser(users, "zztest.veteran10"	, "zztest veteran10"				, "zztest"			, "veteran10"		, "1021206861"			, "05/05/1955"	, "MALE"	, "699999910");
        addPatientUser(users, "zztest.veteran11"	, "zztest veteran11"				, "zztest"			, "veteran11"		, "1010101010"			, "05/05/1951"	, "FEMALE"	, "699999911");
        addPatientUser(users, "zztest.veteran12"	, "zztest veteran12"				, "zztest"			, "veteran12"		, "1010101011"			, "05/05/1952"	, "FEMALE"	, "699999912");
        addPatientUser(users, "zztest.veteran13"	, "zztest veteran13"				, "zztest"			, "veteran13"		, "1010101012"			, "05/05/1953"	, "FEMALE"	, "699999913");
        addPatientUser(users, "zztest.veteran14"	, "zztest veteran14"				, "zztest"			, "veteran14"		, "1010101013"			, "05/05/1954"	, "FEMALE"	, "699999914");
        addPatientUser(users, "zztest.veteran15"	, "zztest veteran15"				, "zztest"			, "veteran15"		, "1010101014"			, "05/05/1955"	, "FEMALE"	, "699999915");
        addPatientUser(users, "zztest.veteran16"	, "zztest veteran16"				, "zztest"			, "veteran16"		, "1010101015"			, "05/05/1951"	, "FEMALE"	, "699999916");
        addPatientUser(users, "zztest.veteran17"	, "zztest veteran17"				, "zztest"			, "veteran17"		, "1010101016"			, "05/05/1952"	, "FEMALE"	, "699999917");
        addPatientUser(users, "zztest.veteran18"	, "zztest veteran18"				, "zztest"			, "veteran18"		, "1010101017"			, "05/05/1953"	, "FEMALE"	, "699999918");
        addPatientUser(users, "zztest.veteran19"	, "zztest veteran19"				, "zztest"			, "veteran19"		, "1010101018"			, "05/05/1954"	, "FEMALE"	, "699999919");
        addPatientUser(users, "zztest.veteran20"	, "zztest veteran20"				, "zztest"			, "veteran20"		, "1010101019"			, "05/05/1955"	, "FEMALE"	, "699999920");
 
        addHealthAdvocateUser(users, "zztest.advocate01"	, "zztest"	, "advocate01"		, "ha1111101"		, "zztest"	, "patient01"		, "D123401"		, "05/05/1900"	, "MALE"	, "899999901");
        addHealthAdvocateUser(users, "zztest.advocate02"	, "zztest"	, "advocate02"		, "ha2222201"		, "zztest"	, "patient02"		, "PATID1"		, "10/05/1900"	, "MALE"	, "899999902");
        addHealthAdvocateUser(users, "zztest.advocate03"	, "zztest"	, "advocate03"		, "0010010011"		, "ONE"		, "VAMOBILEPATIENT"	, "0010010010"	, "01/01/1900"	, "MALE"	, "899999903");
        
        return users;
    }
    
    private void addPatientUser(Map<String, MhpUser> users, String accessCode, String displayName, String firstName,
    							String lastName, String id, String dob, String gender, String ssn) {
        MhpUser user = new MhpUser();
        user.setAccessCode(accessCode);
        user.setDisplayName(displayName);
        user.setFirstName(firstName);
        user.setLastName(lastName);
        user.setUserIdentifier(new PatientIdentifier("EDIPI", id));
        
        user.getPatient().setPatientIdentifier(new PatientIdentifier("EDIPI", id));
        user.getPatient().setFirstName(firstName);
        user.getPatient().setLastName(lastName);
        setPatientDateOfBirth(user, dob);
        user.getPatient().setGender(gender);
        user.getPatient().setSsn(ssn);
        
        users.put(user.getAccessCode(), user);
    }
    
	private void addHealthAdvocateUser(Map<String, MhpUser> users, String accessCode,
                                       String userFirstName, String userLastName, String userId,
                                       String patientFirstName, String patientLastName, String patientId, String dob, String gender, String ssn) {
        MhpUser user = new MhpUser();
        user.setAccessCode(accessCode);
        user.setDisplayName(userFirstName + " " +  userLastName);
        user.setFirstName(userFirstName);
        user.setLastName(userLastName);
        user.setUserIdentifier(new PatientIdentifier("EDIPI", userId));
        
        user.getPatient().setPatientIdentifier(new PatientIdentifier("EDIPI", patientId));
        user.getPatient().setFirstName(patientFirstName);
        user.getPatient().setLastName(patientLastName);
        setPatientDateOfBirth(user, dob);
        
        user.getPatient().setGender(gender);
        user.getPatient().setSsn(ssn);
        
        users.put(user.getAccessCode(), user);
    }
    
    public MhpUser getUser(String username) {
        return getUsers().get(username);
    }
    
    private void setPatientDateOfBirth(MhpUser user, String dob) {
        if (!dob.isEmpty()) {
        	if (dob.contains("/")) {
        		user.getPatient().setDateOfBirth(new DOBDate(DateHelper.parseDate(dob)));
        	} else if (dob.length() == 4) {
        		user.getPatient().setDateOfBirth(new DOBDate("yyyy", dob));
        	} else if (dob.contains(" ")) {
        		user.getPatient().setDateOfBirth(new DOBDate("MMM yyyy", dob));
        	}
        	
            if (user.getPatient().getDateOfBirth() != null && NullChecker.isNotNullish(user.getPatient().getDateOfBirth().getDate())) {
            	user.getPatient().setAge(String.valueOf(DateHelper.calculateDeltaInYears(user.getPatient().getDateOfBirth().getDate(), new Date())));
            }
        }
    }    
}
