package com.agilex.healthcare.mobilehealthplatform.security;

import java.util.*;

import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.User;

import com.agilex.healthcare.mobilehealthplatform.domain.MhpUser;

/**
 * 
 * Models core user information retrieved to be used in SecurityContext. This
 * extends the base class
 * {@link org.springframework.security.core.userdetails.User} which has
 * implementation for basic security attributes. This class (a Composition) also includes
 * {@link MhpUser} and the ProviderID comes from this object (a Delegation)
 * 
 * @author Seena K.
 * 
 */
public class AppUser extends User {

	private MhpUser mhpUser;

	//default values; these are not used within the MHP app at this time.
	private static boolean enabled			 	 = true;
	private static boolean accountNonExpired 	 = true;
	private static boolean credentialsNonExpired = true;
	private static boolean accountNonLocked 	 = true;
	
	private Date lastRequest;
	
	public AppUser(String username, String password, Collection<? extends GrantedAuthority> authorities, MhpUser authenticatedUser) {
		super(username, password, enabled, credentialsNonExpired, accountNonLocked, accountNonExpired, authorities);
	    mhpUser = authenticatedUser;
    }

	public String getProviderId() {
	     return mhpUser.getId();
    }

	public MhpUser getMhpUser() {
	    return mhpUser;
    }
	
	public Date getLastRequest() {
		return lastRequest;
	}

	public void setLastRequest(Date lastRequest) {
		this.lastRequest = lastRequest;
	}

	/**
     * 
     */
    private static final long serialVersionUID = 1L;
    
}
