package com.agilex.healthcare.mobilehealthplatform;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.HttpParams;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.agilex.healthcare.mobilehealthplatform.domain.MhpUser;
import com.agilex.healthcare.mobilehealthplatform.security.AppUser;
import com.agilex.healthcare.utility.DateHelper;

@Controller
public class SSOEProxyController {
	
	private static final String DS_LOGON = "DSLogon";
	private static final String SSN = "SSN";
	private static final String DECODING_FORMAT = "UTF-8";
    private static final String DSLOGON_DATE_FORMAT = "yyyy-MM-dd";
	
    private static String VA_EAUTH_CSID = "va_eauth_csid";
	private static String VA_EAUTH_AUTHENTICATIONMETHOD	= "va_eauth_authenticationmethod";
    private static String VA_EAUTH_AUTHENTICATION_AUTHORITY = "va_eauth_authenticationauthority";

    private static String VA_EAUTH_DODEDIPNID =	"va_eauth_dodedipnid";
    private static String VA_EAUTH_SUBJECT_DODEDIPNID =	"va_eauth_subject_edi";
    private static String VA_EAUTH_SURROGATE_DIDEDIPID= "va_eauth_surrogate_edi";

    private static String VA_EAUTH_ID =	"va_eauth_id";
    private static String VA_EAUTH_ID_TYPE = "va_eauth_idtype";
    private static String VA_EAUTH_FIRSTNAME =	"va_eauth_firstname";
	private static String VA_EAUTH_MIDDLENAME =	"va_eauth_middlename";
	private static String VA_EAUTH_LASTNAME	= "va_eauth_lastname";
	private static String VA_EAUTH_GENDER =	"va_eauth_gender";
	private static String VA_EAUTH_BIRTHDATE =	"va_eauth_birthdate";

    private static String VA_EAUTH_SUBJECT_ID =	"va_eauth_subject_id";
    private static String VA_EAUTH_SUBJECT_ID_TYPE = "va_eauth_subject_idtype";
    private static String VA_EAUTH_SUBJECT_FIRSTNAME =	"va_eauth_subject_firstname";
    private static String VA_EAUTH_SUBJECT_MIDDLENAME =	"va_eauth_subject_middlename";
    private static String VA_EAUTH_SUBJECT_LASTNAME	= "va_eauth_subject_lastname";
    private static String VA_EAUTH_SUBJECT_GENDER =	"va_eauth_subject_gender";
    private static String VA_EAUTH_SUBJECT_BIRTHDATE =	"va_eauth_subject_birthdate";
    
    private static String VA_EAUTH_SURROGATE_LASTNAME = "va_eauth_surrogate_lastName";
    private static String VA_EAUTH_SURROGATE_FIRSTNAME = "va_eauth_surrogate_firstName";
    private static String VA_EAUTH_SURROGATE_MIDDLENAME = "va_eauth_surrogate_middlName";

	@Resource(name="authorizationServicesUrl")
	private String authorizationServicesUrl;
	
	@RequestMapping(value = "/veteran/authorize", method = RequestMethod.GET)
	public void redirectToAuthorizationServices(HttpServletRequest request, HttpServletResponse response) throws Exception{
		
		HttpClient httpclient = new DefaultHttpClient();
		HttpParams params = httpclient.getParams(); 
		params.setParameter("http.protocol.handle-redirects",false);
		HttpGet httpget = new HttpGet(authorizationServicesUrl+"?" + request.getQueryString());
		httpget.setParams(params);
		
		MhpUser user = getCurrentUser();
		
        addDefaultSSOEHeaders(httpget);
	
		if(isUserAPatient(user)){
			addSubjectHeaders(httpget, user);
        } else {
        	addSurrogateAndSubjectHeaders(httpget, user);
		}
		
		HttpResponse resp = httpclient.execute(httpget);

		int statusCode = resp.getStatusLine().getStatusCode();
		
		if (statusCode == 302){
			Header[] headers = resp.getHeaders("Location");
			response.sendRedirect(headers[0].getValue());
		}
		if (statusCode == 500){
			response.sendError(HttpServletResponse.SC_INTERNAL_SERVER_ERROR, resp.toString());
		}

	}

	private boolean isUserAPatient(MhpUser user) {
		return user.getUserIdentifier().equals(user.getPatient().getPatientIdentifier());
	}

	private void addSurrogateAndSubjectHeaders(HttpGet httpget, MhpUser user) {
		httpget.addHeader(VA_EAUTH_SURROGATE_DIDEDIPID, user.getUserIdentifier().getUniqueId());
		httpget.addHeader(VA_EAUTH_SURROGATE_LASTNAME, user.getLastName());
		httpget.addHeader(VA_EAUTH_SURROGATE_FIRSTNAME, user.getFirstName());
		httpget.addHeader(VA_EAUTH_SURROGATE_MIDDLENAME, user.getMiddleInitials());
		httpget.addHeader(VA_EAUTH_SUBJECT_ID_TYPE, SSN);
		httpget.addHeader(VA_EAUTH_SUBJECT_ID, user.getPatient().getSsn());
		httpget.addHeader(VA_EAUTH_SUBJECT_DODEDIPNID, user.getPatient().getPatientIdentifier().getUniqueId());
		httpget.addHeader(VA_EAUTH_SUBJECT_GENDER, user.getPatient().getGender());
		httpget.addHeader(VA_EAUTH_SUBJECT_BIRTHDATE, DateHelper.format(user.getPatient().getDateOfBirth().getDate(), DSLOGON_DATE_FORMAT));
		httpget.addHeader(VA_EAUTH_SUBJECT_FIRSTNAME, user.getPatient().getFirstName());
		httpget.addHeader(VA_EAUTH_SUBJECT_MIDDLENAME, user.getPatient().getMiddleInitial());
		httpget.addHeader(VA_EAUTH_SUBJECT_LASTNAME, user.getPatient().getLastName());
	}

	private void addSubjectHeaders(HttpGet httpget, MhpUser user) {
		httpget.addHeader(VA_EAUTH_SURROGATE_DIDEDIPID, "NOT_FOUND");
		httpget.addHeader(VA_EAUTH_DODEDIPNID, user.getUserIdentifier().getUniqueId());
		httpget.addHeader(VA_EAUTH_LASTNAME, user.getLastName());
		httpget.addHeader(VA_EAUTH_FIRSTNAME, user.getFirstName());
		httpget.addHeader(VA_EAUTH_MIDDLENAME, user.getMiddleInitials());
		httpget.addHeader(VA_EAUTH_ID_TYPE, SSN);
		httpget.addHeader(VA_EAUTH_ID, user.getPatient().getSsn());
		httpget.addHeader(VA_EAUTH_GENDER, user.getPatient().getGender());
		httpget.addHeader(VA_EAUTH_BIRTHDATE, DateHelper.format(user.getPatient().getDateOfBirth().getDate(), DSLOGON_DATE_FORMAT));
	}

	private void addDefaultSSOEHeaders(HttpGet httpget) {
		httpget.addHeader(VA_EAUTH_AUTHENTICATION_AUTHORITY, "D");
        httpget.addHeader(VA_EAUTH_AUTHENTICATIONMETHOD, DS_LOGON);
        httpget.addHeader(VA_EAUTH_CSID, DS_LOGON);
	}
	
	public MhpUser getCurrentUser() {
		SecurityContext securityContext = SecurityContextHolder.getContext();
        Authentication auth = securityContext.getAuthentication();
        AppUser appUser = (AppUser) auth.getPrincipal();
        return appUser.getMhpUser();
	}

}
