package com.agilex.healthcare.mobilehealthplatform;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;

import com.agilex.healthcare.utility.NullChecker;

public class SSOELogoutHandler implements LogoutSuccessHandler {

	private static final String KEY_REDIRECT_URI = "redirect_uri";

	public void onLogoutSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication)
			throws IOException, ServletException {

		String redirectUri = determineRedirectUri(request);
		response.sendRedirect(redirectUri);
	}

	private String determineRedirectUri(HttpServletRequest request) {
		String redirectUri = request.getParameter(KEY_REDIRECT_URI);

		if (NullChecker.isNullish(redirectUri)) {
			redirectUri = "/launchpad/";
		}
		return redirectUri;
	}
}
