#!/bin/bash
# ###########################################################################
# Script generated by HP Fortify SCA Scan Wizard (c) HP Fortify 2011
# Created on 2014/02/10 21:19:51
# ###########################################################################
# Generated for the following languages:
# 	XML
#	Java
#	html
# ###########################################################################
# DEBUG - if set to true, runs SCA in debug mode
# SOURCEANALYZER - the name of the SCA executable
# BUILDID - the SCA build id
# LAUNCHERSWITCHES - the launcher settings that are used to invoke SCA
# ARGFILE - the name of the argument file that's extracted and passed to SCA
# MEMORY - the memory settings for SCA
# OLDFILENUMBER - this defines the file which contains the number of files within the project, it is automatically generated
# FILENOMAXDIFF - this is the percentage of difference between the number of files which will trigger a warning by the script
# ###########################################################################

usage()
{
    echo "Usage:$0 -r <project_root_directory> -d [dependent_jars]"
    echo "OPTIONS:"
    echo "-d    - Dependent Jar files where gradle downloads on the local machine. <optional>"
    echo "        If not set, defaults to $HOME/.gradle/caches/modules-2/files-2.1/**/*.jar(Required for Java Only)"
    echo "-r    - Project Root directory from where fortity to be run. <Mandatory>"
}

DEPENDENT_JARS=""
PROJECTROOT0=""
SOURCE_DIRS=""
EXCLUDE_DIRS=""
APP_TYPE=Java
APP_NAME=""

while getopts “hd:r:” OPTION
do
     case $OPTION in
         h)
            usage
            exit 1
            ;;
         d)
             DEPENDENT_JARS=$OPTARG
             ;;
         r)
             PROJECTROOT0=$OPTARG
             ;;
     esac
done

FORTIFY_CONFIG="fortifyConfig.properties"

if [ ! -e "$FORTIFY_CONFIG" ]; then
    echo "Fortify configuration file does not exist";
    exit;
fi

while read line
do 
    # Ignore the comments in the configuration file
    if [[ "$line" == "#"* ]]; then
        continue;
    fi
    # Get the exclude directories list
    if [[ "$line" == *"excludeDirs"* ]]; then
        EXCLUDE_DIRS="$(cut -d '=' -f 2 <<< "$line")"; 
    fi
    # Get the source directories list
    if [[ "$line" == *"sourceDirs"* ]]; then
        SOURCE_DIRS="$(cut -d '=' -f 2 <<< "$line")"; 
    fi
    # Get the application name 
    if [[ "$line" == *"appName"* ]]; then
        APP_NAME="$(cut -d '=' -f 2 <<< "$line")"; 
    fi
    # Get the application type 
    if [[ "$line" == *"appType"* ]]; then
        APP_TYPE="$(cut -d '=' -f 2 <<< "$line")"; 
    fi
done  < $FORTIFY_CONFIG

if [ -z $DEPENDENT_JARS ]; then
    DEPENDENT_JARS="$HOME/.gradle/caches/modules-2/files-2.1/**/*.jar"
fi

if [ -z $PROJECTROOT0 ]; then
    echo "-r option: Project root directory not set as argument"
    usage
    exit 1
fi

if [ -z $SOURCE_DIRS ]; then
    echo "Source directories to scan not set in config file"
    usage
    exit 1
fi

if [ -z $APP_NAME ]; then
    echo "Application Name not set in config file"
    usage
    exit 1
fi

DEBUG=false
SOURCEANALYZER=sourceanalyzer
FPR="Fortify$APP_NAME.fpr"
BUILDID="$APP_NAME"
ARGFILE="Fortify$APP_NAME.sh.args"
MEMORY="-Xmx3200M -Xms2400M -Xss48M "

LAUNCHERSWITCHES=""
OLDFILENUMBER=Fortify$APP_NAME.sh.fileno
FILENOMAXDIFF=100

if [ ! -d "$PROJECTROOT0" ]; then
   echo  "ERROR: This script is  configured to locate files at"
   echo  "          $PROJECTROOT0"
   echo  "       Please specify the correct \$PROJECTROOT0 variable as argument to the script.\n"
   usage
   exit
fi

if [ $DEBUG = true ]; then export LAUNCHERSWITCHES="-debug $LAUNCHERSWITCHES"; fi

#####################################################################################
## Add all the exclude directories list
#####################################################################################
if [ ! -z $EXCLUDE_DIRS ]; then
    OIFS=$IFS;
    IFS=",";
   
    dirsArray=($EXCLUDE_DIRS);
    EXCLUDE_DIR=""
    for ((i=0; i<${#dirsArray[@]}; ++i));
    do
        EXCLUDE_DIR=$EXCLUDE_DIR" -exclude $PROJECTROOT0/${dirsArray[$i]}";
    done

    IFS=$OIFS;
fi

#####################################################################################
## Add all the source directories to scan 
#####################################################################################
if [ ! -z $SOURCE_DIRS ]; then
    OIFS=$IFS;
    IFS=",";
   
    dirsArray=($SOURCE_DIRS);
    SOURCE_TO_SCAN=""
    for ((i=0; i<${#dirsArray[@]}; ++i));
    do
        SOURCE_TO_SCAN=$SOURCE_TO_SCAN" $PROJECTROOT0/${dirsArray[$i]}";
    done

    IFS=$OIFS;
fi


# ###########################################################################
echo Cleaning previous scan artifacts
$SOURCEANALYZER $MEMORY $LAUNCHERSWITCHES -b $BUILDID -clean 
if [ $? = 1 ] ; then
echo Sourceanalzyer failed, exiting
exit
fi
# ###########################################################################
echo Translating files
## Specify the files which need to be scanned and exclude the files on which no fortify report needed.
#############################################################################
#shopt -s nocasematch
if [ "$APP_TYPE" == "Java" ]; then
    $SOURCEANALYZER $MEMORY $LAUNCHERSWITCHES -b $BUILDID -source 1.6 -cp $DEPENDENT_JARS:$JAVA_HOME/**/Classes/*.jar  $EXCLUDE_DIR  $SOURCE_TO_SCAN
elif [ "$APP_TYPE" == "WebApp" ]; then
    $SOURCEANALYZER $MEMORY $LAUNCHERSWITCHES -b $BUILDID -source 1.6 $EXCLUDE_DIR  $SOURCE_TO_SCAN
else
    echo "Application Type not set in the configuration file"
    exit 1
fi
#shopt -u nocasematch

if [ $? = 1 ] ; then
echo Sourceanalzyer failed, exiting
exit
fi
# ###########################################################################
echo Testing Difference between Translations
FILENUMBER=`$SOURCEANALYZER -verbose -b $BUILDID -show-files $SOURCE_TO_SCAN | wc -l`

echo $FILENUMBER
if [ ! -f $OLDFILENUMBER ]; then
	echo It appears to be the first time running this script, setting $OLDFILENUMBER to $FILENUMBER
	echo $FILENUMBER > $OLDFILENUMBER
else
	OLDFILENO=`cat $OLDFILENUMBER`
	DIFF=`expr $OLDFILENO "*" $FILENOMAXDIFF`
	DIFF=`expr $DIFF /  100`

	MAX=`expr $OLDFILENO + $DIFF`
	MIN=`expr $OLDFILENO - $DIFF`

	if [ $FILENUMBER -lt $MIN ] ; then SHOWWARNING=true; fi
	if [ $FILENUMBER -gt $MAX ] ; then SHOWWARNING=true; fi

	if [ $SHOWWARNING == true ] ; then
		echo "WARNING: The number of files has changed by over $FILENOMAXDIFF%, it is recommended"
		echo "         that this script is regenerated with the ScanWizard"
	fi

	echo $MAX $MIN $DIFF
fi;

# ###########################################################################
echo Starting scan
$SOURCEANALYZER $MEMORY $LAUNCHERSWITCHES -b $BUILDID -scan -f $FPR
if [ $? = 1 ] ; then
echo Sourceanalzyer failed, exiting
exit
fi
