#!/bin/sh
# ###########################################################################
# Script generated by HP Fortify SCA Scan Wizard (c) HP Fortify 2011
# Created on 2014/02/10 21:19:51
# ###########################################################################
# Generated for the following languages:
# 	XML
# ###########################################################################
# DEBUG - if set to true, runs SCA in debug mode
# SOURCEANALYZER - the name of the SCA executable
# BUILDID - the SCA build id
# LAUNCHERSWITCHES - the launcher settings that are used to invoke SCA
# ARGFILE - the name of the argument file that's extracted and passed to SCA
# MEMORY - the memory settings for SCA
# OLDFILENUMBER - this defines the file which contains the number of files within the project, it is automatically generated
# FILENOMAXDIFF - this is the percentage of difference between the number of files which will trigger a warning by the script
# ###########################################################################

DEBUG=false
SOURCEANALYZER=sourceanalyzer
FPR="Fortify-HA-3.3.0.fpr"
BUILDID="HA"
ARGFILE="Fortify-HA-3.3.0.sh.args"
MEMORY="-Xmx3200M -Xms2400M -Xss48M "

usage()
{
    echo "Usage:$0 options"
    echo "This script run with optional arguments."
    echo "OPTIONS:"
    echo "-d    Dependent Jar files where gradle downloads on the local machine."
    echo "      If not set, defaults to $HOME/.gradle/artifacts-24/filestore/**/.jar"
    echo "-r    Project Root directory from where fortity to be run."
    echo "      If not set, defaults to $HOME/ihealthadapter/Product/Production"
}

DEPENDENT_JARS=
PROJECTROOT0=
while getopts “hd:r:” OPTION
do
     case $OPTION in
         h)
            usage
            exit 1
            ;;
         d)
             DEPENDENT_JARS=$OPTARG
             ;;
         r)
             PROJECTROOT0=$OPTARG
             ;;
     esac
done


if [ -z $DEPENDENT_JARS ]; then
    DEPENDENT_JARS="$HOME/.gradle/caches/modules-2/files-2.1/**/*.jar"
fi

if [ -z $PROJECTROOT0 ]; then
    PROJECTROOT0="$HOME/ihealthadapter_3.3.0/ihealthadapter/Product/Production";
fi

LAUNCHERSWITCHES=""
OLDFILENUMBER=Fortify-HA-3.3.0.sh.fileno
FILENOMAXDIFF=100

if [ ! -d "$PROJECTROOT0" ]; then
   echo  "ERROR: This script is  configured to locate files at"
   echo  "          $PROJECTROOT0"
   echo  "       Please specify the correct \$PROJECTROOT0 variable as argument to the script.\n"
   usage
   exit
fi

if [ $DEBUG = true ]; then export LAUNCHERSWITCHES="-debug $LAUNCHERSWITCHES"; fi

# ###########################################################################
echo Cleaning previous scan artifacts
$SOURCEANALYZER $MEMORY $LAUNCHERSWITCHES -b $BUILDID $PROJECTROOT0/HealthAdapter/src/main/**/* -clean 
if [ $? = 1 ] ; then
echo Sourceanalzyer failed, exiting
exit
fi
# ###########################################################################
echo Translating files $PROJECTROOT0
$SOURCEANALYZER $MEMORY $LAUNCHERSWITCHES -b $BUILDID -source 1.6 -cp $DEPENDENT_JARS:$JAVA_HOME/**/Classes/*.jar -exclude "$PROJECTROOT0/MobileHealthPlatformAuthentication/**/*" -exclude "$PROJECTROOT0/MobileHealthPlatformGoogleLib/**/*" -exclude "$PROJECTROOT0/MobileHealthPlatformMetricsWeb/**/*" -exclude "$PROJECTROOT0/MobileHealthPlatformAuthentication/**/*" -exclude "$PROJECTROOT0/MobileHealthPlatformGoogleLib/**/*" -exclude "$PROJECTROOT0/MobileHealthPlatformOVIDLib/**/*" -exclude "$PROJECTROOT0/MobileHealthPlatformS3Lib/**/*" -exclude "$PROJECTROOT0/MobileHealthPlatformKMRLib/**/*" -exclude "$PROJECTROOT0/TimingLogParser/**/*" -exclude "$PROJECTROOT0/ssoeproxy/**/*" -exclude "$PROJECTROOT0/TPRestServicesWeb/**/*" -exclude "$PROJECTROOT0/ResourceIntTest/**/*" -exclude "$PROJECTROOT0/ovid/**/*" -exclude "$PROJECTROOT0/ovid-1.1/**/*" -exclude "$PROJECTROOT0/ovid-domain/**/*" -exclude "$PROJECTROOT0/ovid-domain-1.1/**/*" -exclude "$PROJECTROOT0/**/inttest/**/*" -exclude "$PROJECTROOT0/**/src/main/webapp/**/*.js" -exclude "$PROJECTROOT0/DataLayerStub/**/*" -exclude "$PROJECTROOT0/HAAuthorizationServicesLib/**/*" $PROJECTROOT0/**/src/main/**/*
if [ $? = 1 ] ; then
echo Sourceanalzyer failed, exiting
exit
fi
# ###########################################################################
echo Testing Difference between Translations
FILENUMBER=`$SOURCEANALYZER -verbose -b $BUILDID -show-files $PROJECTROOT0/**/src/main/**/* | wc -l`

echo $FILENUMBER
if [ ! -f $OLDFILENUMBER ]; then
	echo It appears to be the first time running this script, setting $OLDFILENUMBER to $FILENUMBER
	echo $FILENUMBER > $OLDFILENUMBER
else
	OLDFILENO=`cat $OLDFILENUMBER`
	DIFF=`expr $OLDFILENO "*" $FILENOMAXDIFF`
	DIFF=`expr $DIFF /  100`

	MAX=`expr $OLDFILENO + $DIFF`
	MIN=`expr $OLDFILENO - $DIFF`

	if [ $FILENUMBER -lt $MIN ] ; then SHOWWARNING=true; fi
	if [ $FILENUMBER -gt $MAX ] ; then SHOWWARNING=true; fi

	if [ $SHOWWARNING == true ] ; then
		echo "WARNING: The number of files has changed by over $FILENOMAXDIFF%, it is recommended"
		echo "         that this script is regenerated with the ScanWizard"
	fi

	echo $MAX $MIN $DIFF
fi;

# ###########################################################################
echo Starting scan
$SOURCEANALYZER $MEMORY $LAUNCHERSWITCHES -b $BUILDID -scan -f $FPR
if [ $? = 1 ] ; then
echo Sourceanalzyer failed, exiting
exit
fi
