package com.agilex.va.mpi.service;

import com.agilex.va.mpi.config.MpiConfig;
import com.agilex.va.mpi.model.*;
import com.agilex.soap.*;

public class VaMpiService {

    private final MpiConfig config;

    public VaMpiService(MpiConfig config) {
        this.config = config;
    }

    public PatientCorrelationId[] getPatientIds(String sourceAssigningAuthority, PatientCorrelationId sourceIdentifier) {
        Service service = new Service(config.getEndPoint(), config.getConnectionTimeout(), config.getReadTimeout());

        GetIdsRequestBuilder requestBuilder = new GetIdsRequestBuilder(IdTransformer.getAssigningAuthorityRoot(sourceAssigningAuthority), sourceIdentifier.createHl7Id());

        Message request = requestBuilder.build();
        Message response = request.send(service);


        GetIdsResponse idsResponse = new GetIdsResponse(response);

        idsResponse.processMessage();
        return idsResponse.getIds();
    }

}
