package com.agilex.va.mpi.model;

import com.google.common.base.Joiner;

public class SystemContext {
    private final String source;
    private final String issuer;

    public SystemContext(String assigningAuthority) {
        this(IdTransformer.getSource(assigningAuthority),
             IdTransformer.getIssuer(assigningAuthority));
    }

    public SystemContext(String source, String issuer) {
        this.source = source;
        this.issuer = issuer;
    }

    public String getAssigningAuthority() {
        return IdTransformer.getAssigningAuthority(issuer, source);
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof SystemContext && source.equals(((SystemContext) obj).source) &&
                issuer.equals(((SystemContext) obj).issuer);
    }

    @Override
    public int hashCode() {
        return source.hashCode() + issuer.hashCode();
    }

    @Override
    public String toString() {
        Joiner joiner = Joiner.on(" ").skipNulls();
        return combine(joiner);
    }

    public String combine(Joiner joiner) {
        return joiner.join(source, issuer);
    }
}
