package com.agilex.va.mpi.model;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;

import java.util.List;
import java.util.Locale;


public class IdTransformer {
    private static List<String> vistaFacilities;

    private static final ImmutableMap<String, String> idTypes = ImmutableMap.of("EDIPI", "NI",
                                                                                "ICN", "NI",
                                                                                "mock-aa", "PI");

    private static final ImmutableMap<String, String> sources = ImmutableMap.of("EDIPI", "200DOD",
                                                                                "ICN", "200M",
                                                                                "mock-aa", "313");

    private static final ImmutableMap<String, String> issuers = ImmutableMap.of("EDIPI", "USDOD",
                                                                                "ICN", "USVHA",
                                                                                "mock-aa", "USVHA");

    private static final ImmutableMap<String, String> roots = ImmutableMap.of("EDIPI", "2.16.840.1.113883.3.364",
                                                                              "ICN", "2.16.840.1.113883.4.349",
                                                                              "mock-aa", "2.16.840.1.113883.4.349");

    public static void initVistaFacilities(String commaSeparateList) {
        if (vistaFacilities != null)
            return;

        intVistaFacilities(commaSeparateList);
    }

    private static synchronized void intVistaFacilities(String commaSeparateList) {
        if (vistaFacilities != null)
            return;

        Splitter splitter = Splitter.on(",").trimResults().omitEmptyStrings();

        Iterable<String> list = splitter.split(commaSeparateList);
        vistaFacilities = Lists.newArrayList(list);
    }

    public static String getIdType(String assigningAuthority) {
        return isVistaAssigningAuthority(assigningAuthority) ? "PI" : idTypes.get(assigningAuthority);
    }

    public static String getSource(String assigningAuthority) {
        return isVistaAssigningAuthority(assigningAuthority) ? assigningAuthority.substring(4) :sources.get(assigningAuthority);
    }

    public static String getIssuer(String assigningAuthority) {
        return isVistaAssigningAuthority(assigningAuthority) ? "USVHA" : issuers.get(assigningAuthority);
    }

    public static String getAssigningAuthorityRoot(String assigningAuthority) {
        return isVistaAssigningAuthority(assigningAuthority) ? "2.16.840.1.113883.4.349" : roots.get(assigningAuthority);
    }

    private static boolean isVistaAssigningAuthority(String assigningAuthority) {
        return assigningAuthority.toLowerCase(Locale.ENGLISH).startsWith("dfn-");
    }

    public static String getAssigningAuthority(String issuer, String source) {
        // FIXME hard coded for now.  Need to move to file.
        if ("USDOD".equals(issuer))
            return "EDIPI";
        else if ("200M".equals(source) && "USVHA".equals(issuer))
            return "ICN";
        else if ("313".equals(source) && "USVHA".equals(issuer))
            return "mock-aa";
        else if ("USVHA".equals(issuer) && vistaFacilities.contains(source))
            return "dfn-" + source;

        return "";
    }
}

//mock-aa   -> PI   313     USVHA   2.16.840.1.113883.4.349
//EDPI      -> NI   200DOD  USDOD   2.16.840.1.113883.3.364
//ICN       -> NI   200M    USVHA   2.16.840.1.113883.4.349 + CDW -> NI 200M USVHA 2.16.840.1.113883.4.349
//vista-345 -> PI   354     USVHA   2.16.840.1.113883.4.349
