package com.agilex.va.mpi.model;

import com.agilex.soap.*;
import com.agilex.soap.exceptions.SoapMessageException;
import com.agilex.soap.exceptions.SoapServiceException;

import java.util.List;

public class GetIdsResponse {
    private static final String PREFIX = "ns1";
    private static final String NAME_SPACE = "urn:hl7-org:v3";
    private static final String ID = "id";
    private static final String EXTENSION = "extension";
    public static final String SUCCESS_ACK = "AA";
    public static final String CODE = "code";
    private final static String[] typeNodeNames = new String[] {"acknowledgement", "typeCode"};
    private final static String[] ackDetailTextNodeNames = new String[] {"acknowledgement", "acknowledgementDetail", "text"};
    private final static String[] patientIdsNodeNames = new String[] {"controlActProcess", "subject", "registrationEvent", "subject1", "patient"};

    private final Message message;

    public GetIdsResponse(Message message) {
        this.message = message;
    }

    public void processMessage() {
        if (isFailure())
            throw getMessageException();
    }

    private boolean isFailure() {
        boolean failure = true;

        if (SUCCESS_ACK.equals(getAck()))
            failure = false;

        return failure;
    }

    private String getAck() {
        return getRootElement().getChild(typeNodeNames, PREFIX, NAME_SPACE)
                               .getAttributeValue(CODE);
    }

    public RuntimeException getMessageException() {
        if (message.getBody().hasFault())
            return new SoapServiceException(message.getBody().getFault().getFaultReason());

        String messageText = getMessageText();

        if (messageText == null)
            throw new SoapMessageException("Cannot generate exception for message. There was an error code in the message but there is not any exception information in the message.");

        if (isInvalidIdType(messageText) || isInvalidIdFormat(messageText) || isUnknownId(messageText))
            return new IllegalArgumentException(messageText);

        return new SoapMessageException(messageText);
    }

    private String getMessageText() {
        Element element = getRootElement();

        return element.getChild(ackDetailTextNodeNames, PREFIX, NAME_SPACE)
                      .getElementValue();
    }

    private Element getRootElement() {
        return message.getBody().getRootElement();
    }

    private boolean isUnknownId(String messageText) {
        return messageText.toLowerCase().contains("correlation does not exist");
    }

    private boolean isInvalidIdFormat(String messageText) {
        return messageText.toLowerCase().contains("invalid vpid format");
    }

    private boolean isInvalidIdType(String messageText) {
        return messageText.toLowerCase().contains("invalid identifier type");
    }

    public PatientCorrelationId[] getIds() {
        List<String> ids = getIdsFromMessage();

        PatientCorrelationId[] patientCorrelationIdentifiers = new PatientCorrelationId[ids.size()];

        for (int i = 0; i <= ids.size()-1; i++) {
            PatientCorrelationId identifier = new PatientCorrelationId(ids.get(i));

            patientCorrelationIdentifiers[i] = identifier;
        }

        return patientCorrelationIdentifiers;
    }

    private List<String> getIdsFromMessage() {
        Element element = getRootElement().getChild(patientIdsNodeNames, PREFIX, NAME_SPACE);
        Elements elements = element.getChildren(ID, PREFIX, NAME_SPACE);

        return elements.getAttributeValue(EXTENSION);
    }
}
