package com.agilex.va.mpi.model;

import com.agilex.soap.*;

import java.text.*;
import java.util.*;

public class GetIdsRequestBuilder {
    private static final String[] deviceAttributes = new String[]{"determinerCode", "classCode"};
    private static final String[] deviceAttributeValues = new String[]{"INSTANCE", "DEV"};
    private static final String[] idAttributes = new String[]{"root", "extension"};
    private static final String mviId = "2.16.840.1.113883.4.349";
    private static final String haId = "2.16.840.1.113883.3.933";
    private static final String actionId = "2.16.840.1.113883.1.6";
    private static final String NAMESPACE = "urn:hl7-org:v3";
    private static final String ID = "id";
    private static final String DEVICE = "device";
    private static final String TYPE_CODE = "typeCode";
    private static final String CODE = "code";
    private static final String ROOT = "root";
    public static final String VALUE = "value";

    private final String root;
    private final String extension;

    public GetIdsRequestBuilder(String root, String extension) {
        this.root = root;
        this.extension = extension;
    }

    public Message build() {
        Message message = new Message();
        message.removeHeader();

        Body body = message.getBody();
        Element bodyElement = body.addChild("PRPA_IN201309UV02", "ns2", "http://vaww.oed.oit.domain");

        bodyElement.addNamespace(NAMESPACE)
                   .addAttribute("ITSVersion", "XML_1.0");

        bodyElement.addChildWithAttributes(ID, idAttributes, new String[]{mviId, UUID.randomUUID().toString()});
        bodyElement.addChildWithAttribute("creationTime", VALUE, now());
        bodyElement.addChildWithAttributes("interactionId", idAttributes, new String[]{actionId, "PRPA_IN201309UV02"});
        bodyElement.addChildWithAttribute("processingCode", CODE, "T");
        bodyElement.addChildWithAttribute("processingModeCode", CODE, "T");
        bodyElement.addChildWithAttribute("acceptAckCode", CODE, "AL");

        createReceiverNode(bodyElement);
        createSenderNode(bodyElement);
        createControlActProcessNode(bodyElement);

        return message;
    }

    private String now() {
        DateFormat df = new SimpleDateFormat("yyyyMMddHHmmss");
        return df.format(new Date());
    }

    private void createReceiverNode(Element bodyElement) {
        bodyElement.addChildWithAttribute("receiver", TYPE_CODE, "RCV")
                   .addChildWithAttributes(DEVICE, deviceAttributes, deviceAttributeValues)
                   .addChildWithAttribute(ID, ROOT, mviId);
    }

    private void createSenderNode(Element bodyElementWrapper) {
        bodyElementWrapper.addChildWithAttribute("sender", TYPE_CODE, "SND")
                          .addChildWithAttributes(DEVICE, deviceAttributes, deviceAttributeValues)
                          .addChildWithAttributes(ID, idAttributes, new String[]{haId, "200CIH"});
    }

    private void createControlActProcessNode(Element bodyElementWrapper) {
        Element controlActProcess = bodyElementWrapper.addChild("controlActProcess")
                                                      .addAttributes(new String[]{"moodCode", "classCode"}, new String[]{"EVN", "CACT"});

        controlActProcess.addChild(CODE)
                         .addAttributes(new String[] {"codeSystem", CODE}, new String[] {actionId, "PRPA_TE201309UV02"});

        Element queryByParameter = controlActProcess.addChild("queryByParameter");

        queryByParameter.addChildWithAttributes("queryId", idAttributes, new String[]{haId, UUID.randomUUID().toString()});
        queryByParameter.addChildWithAttribute("statusCode", CODE, "new");
        queryByParameter.addChildWithAttribute("responsePriorityCode", CODE, "I");

        Element patientIdentifier = queryByParameter.addChild("parameterList")
                                                    .addChild("patientIdentifier");

        patientIdentifier.addChildWithAttributes(VALUE, idAttributes, new String[]{root, extension});

        patientIdentifier.addChild("semanticsText")
                         .addElementValue("Patient.Id");
    }
}
