package com.agilex.va.mpi.config;

import java.io.Serializable;

public class MpiConfig implements Serializable {
    private static final long serialVersionUID = -4623525270601091105L;

    private String endPoint = "http://localhost:8088/mockVAIdMPort";
    private int connectionTimeout = 5000;
    private int readTimeout = 60000;
    private String vistaFacilities;

    public MpiConfig() {}

    public MpiConfig(String endPoint, int connectionTimeout, int readTimeout, String vistaFacilities) {
        this.endPoint = endPoint;
        this.connectionTimeout = connectionTimeout;
        this.readTimeout = readTimeout;
        this.vistaFacilities = vistaFacilities;
    }

    public void setEndPoint(String endPoint) {
        this.endPoint = endPoint;
    }

    public String getEndPoint() {
        return endPoint;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public int getConnectionTimeout() {
        return connectionTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public int getReadTimeout() {
        return readTimeout;
    }

    public String getVistaFacilities() {
        return vistaFacilities;
    }

    public void setVistaFacilities(String vistaFacilities) {
        this.vistaFacilities = vistaFacilities;
    }

    @Override
    public String toString() {
        return "Endpoint: " + endPoint + ", Connection Timeout: " + connectionTimeout + ", Read Timeout: " + readTimeout;
    }
}
