package com.agilex.va.mpi.cache;

import com.agilex.va.mpi.model.PatientCorrelationId;

public class LastInCacheService implements CacheService {

    private PatientCorrelationId key;
    private PatientCorrelationId[] identifiers;

    public void add(PatientCorrelationId key, PatientCorrelationId[] correlationIds) {
        this.key = key;
        identifiers = correlationIds;
    }

    public boolean contains(PatientCorrelationId key) {
         return this.key != null && this.key.equals(key);
    }

    public PatientCorrelationId[] match(PatientCorrelationId key) {
        if (!contains(key))
            return CacheService.EMPTY_ID_LIST;

        return identifiers;
    }
}
