package com.agilex.va.mpi.cache;

import com.agilex.va.mpi.model.PatientCorrelationId;

import java.util.concurrent.*;

public class HashMapCacheService implements CacheService {
    private static final ConcurrentMap<PatientCorrelationId, PatientCorrelationId[]> map = new ConcurrentHashMap<PatientCorrelationId, PatientCorrelationId[]>();

    public void  add(PatientCorrelationId key, PatientCorrelationId[] correlationIds) {
        map.put(key, correlationIds);
    }

    public boolean contains(PatientCorrelationId key) {
        return map.containsKey(key);
    }

    public PatientCorrelationId[] match(PatientCorrelationId key) {
        if (!contains(key))
            return CacheService.EMPTY_ID_LIST;

        return map.get(key);
    }
}
