package com.agilex.va.mpi.cache;

import com.agilex.va.mpi.model.PatientCorrelationId;
import net.sf.ehcache.CacheManager;

public class EhCacheService implements CacheService  {
    private static final String CACHE_NAME = "mvipatientidcache";
    private static EhCacheAdapter<PatientCorrelationId, PatientCorrelationId[]> cacheAdapter;

    //Will hold last add by an instance so adder can get match even if there is an issue with ehcache.
    //Being very pessimistic (ex. someone messes up ehcache configuration.)
    //Do not use in contains method.  This is only helpful when an item is added and match is returned from the
    //same instance.
    private final LastInCacheService lastInCacheService = new LastInCacheService();

    private static boolean isAvailable = true;

    private static final org.apache.commons.logging.Log logger = org.apache.commons.logging.LogFactory.getLog(EhCacheService.class);

    static  {
        try {
            CacheManager cacheManager = CacheManager.create(EhCacheService.class.getResource("/config/ehcache.xml"));
            cacheAdapter = new EhCacheAdapter<PatientCorrelationId, PatientCorrelationId[]>(CACHE_NAME, cacheManager);
            isAvailable = true;
        } catch (Exception e ) {
            logger.error(e);
            isAvailable = false;
        }
    }

    public static boolean isAvailable() {
        return isAvailable;
    }

    public void add(PatientCorrelationId key, PatientCorrelationId[] correlationIds) {
        try {
            lastInCacheService.add(key, correlationIds);
            cacheAdapter.put(key, correlationIds);
        } catch (Exception e ) {
            logger.error(e);
            isAvailable = false;
        }
    }

    public boolean contains(PatientCorrelationId key) {
        PatientCorrelationId[] ids = getValue(key);

        return ids != null;
    }

    public PatientCorrelationId[] match(PatientCorrelationId key) {
        if (lastInCacheService.contains(key))
            return lastInCacheService.match(key);

        PatientCorrelationId[] ids = getValue(key);

        if (ids != null)
            return ids;

        return CacheService.EMPTY_ID_LIST;
    }

    private PatientCorrelationId[] getValue(PatientCorrelationId key) {
        PatientCorrelationId[] ids = null;

        try {
            ids = cacheAdapter.get(key);
        } catch (Exception e ) {
            logger.debug("Failed go get correlation for a patient correlation key", e);
            isAvailable =false;
        }

        return ids;
    }
}
