package com.agilex.va.mpi.cache;

import net.sf.ehcache.*;

public class EhCacheAdapter<K, V>
{
    private final String cacheName;
    private final CacheManager cacheManager;

    public EhCacheAdapter(String cacheName, CacheManager cacheManager)
    {
        this.cacheName = cacheName;
        this.cacheManager = cacheManager;
    }

    public void put(K key, V value)
    {
        getCache().put(new Element(key, value));
    }

    public V get(K key)
    {
        Element element = getCache().get(key);
        if (element != null) {
            return (V) element.getValue();
        }
        return null;
    }

    public Ehcache getCache()
    {
        return cacheManager.getEhcache(cacheName);
    }
}