package com.agilex.va.mpi.cache;

public class CacheFactory {
    public enum CacheType {
        LastIn, HashMap, EhCache
    }

    public static CacheType defaultCacheType = CacheType.EhCache;

    public CacheService getCacheService() {
        return getCacheService(defaultCacheType);
    }

    public CacheService getCacheService(CacheType cacheType) {
        switch(cacheType) {
            case EhCache: return createEhCache();
            case HashMap: return new HashMapCacheService();
            default: return new LastInCacheService();
        }
    }

    private CacheService createEhCache() {
        CacheService cacheService = null;

        if (EhCacheService.isAvailable())
            cacheService = new EhCacheService();

        if (!EhCacheService.isAvailable())
            //EhCache fails to initialize or fails during operation
            cacheService = new LastInCacheService();

        return cacheService;
    }
}
