package com.agilex.healthcare.mobilehealthplatform.timinglog.domain;

// Generated Jun 10, 2011 1:02:56 PM by Hibernate Tools 3.4.0.CR1

import java.util.List;
import javax.naming.InitialContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.LockMode;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Example;

/**
 * Home object for domain model class EventData.
 * @see com.agilex.healthcare.mobilehealthplatform.timinglog.domain.EventData
 * @author Hibernate Tools
 */
public class EventDataHome {

	private static final Log log = LogFactory.getLog(EventDataHome.class);

	private final SessionFactory sessionFactory = getSessionFactory();

	protected SessionFactory getSessionFactory() {
		try {
			return (SessionFactory) new InitialContext().lookup("SessionFactory");
		} catch (Exception e) {
			log.error("Could not locate SessionFactory in JNDI", e);
			throw new IllegalStateException("Could not locate SessionFactory in JNDI");
		}
	}

	public void persist(EventData transientInstance) {
		log.debug("persisting EventData instance");
		try {
			sessionFactory.getCurrentSession().persist(transientInstance);
			log.debug("persist successful");
		} catch (RuntimeException re) {
			log.error("persist failed", re);
			throw re;
		}
	}

	public void attachDirty(EventData instance) {
		log.debug("attaching dirty EventData instance");
		try {
			sessionFactory.getCurrentSession().saveOrUpdate(instance);
			log.debug("attach successful");
		} catch (RuntimeException re) {
			log.error("attach failed", re);
			throw re;
		}
	}

	public void attachClean(EventData instance) {
		log.debug("attaching clean EventData instance");
		try {
			sessionFactory.getCurrentSession().lock(instance, LockMode.NONE);
			log.debug("attach successful");
		} catch (RuntimeException re) {
			log.error("attach failed", re);
			throw re;
		}
	}

	public void delete(EventData persistentInstance) {
		log.debug("deleting EventData instance");
		try {
			sessionFactory.getCurrentSession().delete(persistentInstance);
			log.debug("delete successful");
		} catch (RuntimeException re) {
			log.error("delete failed", re);
			throw re;
		}
	}

	public EventData merge(EventData detachedInstance) {
		log.debug("merging EventData instance");
		try {
			EventData result = (EventData) sessionFactory.getCurrentSession().merge(detachedInstance);
			log.debug("merge successful");
			return result;
		} catch (RuntimeException re) {
			log.error("merge failed", re);
			throw re;
		}
	}

	public EventData findById(com.agilex.healthcare.mobilehealthplatform.timinglog.domain.EventDataId id) {
		log.debug("getting EventData instance with id: " + id);
		try {
			EventData instance = (EventData) sessionFactory.getCurrentSession().get("com.agilex.healthcare.mobilehealthplatform.timinglog.domain.EventData", id);
			if (instance == null) {
				log.debug("get successful, no instance found");
			} else {
				log.debug("get successful, instance found");
			}
			return instance;
		} catch (RuntimeException re) {
			log.error("get failed", re);
			throw re;
		}
	}

	@SuppressWarnings("unchecked")
	public List<EventData> findByExample(EventData instance) {
		log.debug("finding EventData instance by example");
		try {
			List<EventData> results = sessionFactory.getCurrentSession().createCriteria("com.agilex.healthcare.mobilehealthplatform.timinglog.domain.EventData").add(Example.create(instance)).list();
			log.debug("find by example successful, result size: " + results.size());
			return results;
		} catch (RuntimeException re) {
			log.error("find by example failed", re);
			throw re;
		}
	}
}
