package com.agilex.healthcare.mobilehealthplatform.timinglog;

import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;

import com.agilex.healthcare.mobilehealthplatform.timinglog.domain.Event;
import com.agilex.healthcare.mobilehealthplatform.timinglog.domain.EventData;

public class Storer {

	private SessionFactory sessionFactory = new Configuration().configure().buildSessionFactory();;

	public void StoreEvent(Event e) {
		Session session = null;
		try {
			log("request to store event");

			log("initialize session");
			session = sessionFactory.openSession();

			log("begin transaction");
			session.beginTransaction();

			log("save event");
			session.save(e);
			for (EventData eventdata : e.getEventDatas()) {
				log("save event data");
				eventdata.setEvent(e);
				eventdata.getId().setEventId(e.getId());
				session.save(eventdata);
			}

			log("commit transaction");

			try {
				session.getTransaction().commit();
			} catch (org.hibernate.exception.ConstraintViolationException ex) {
				log("ignoring constraint exception.  " + ex);
			}

			log("event stored");
		} finally {
			log("release session");
			if (session != null)
				session.close();
			// HibernateUtil.getSessionFactory().close();
		}
	}

	private void log(String message) {
//		System.out.println(message);
	}

}
