package com.agilex.healthcare.mobilehealthplatform.timinglog;

import java.io.File;
import java.io.FilenameFilter;
import java.util.UUID;

public class Runner {
	private static final String INPUTDIRECTORY = "/mhp/metrics/input";
	private static final String PROCESSED_DIRECTORY = "/mhp/metrics/input/complete";
	private static final String ERROR_DIRECTORY = "/mhp/metrics/input/error";

	public static void main(String args[]) {
		Parser fileParser = new Parser();

		File directory = new File(INPUTDIRECTORY);

		FilenameFilter filter = new FilenameFilter() {
			@Override
			public boolean accept(File dir, String name) {
				if (name.startsWith("mhp.timings"))
					return true;
				else if (name.contains("mhp.timings"))
					return true;
				else
					return false;
			}
		};

		String[] files = directory.list(filter);
		if (files == null) {
			System.out.println("no files meeting pattern " + INPUTDIRECTORY);
		} else {
			for (int i = 0; i < files.length; i++) {
				String basefilename = files[i];
				File f = new File(directory, basefilename);
				String filename = f.toString();
				try {
					System.out.println(String.format("Processing file %s (%s/%s)", filename, i + 1, files.length));
					fileParser.processFile(filename);
					System.out.println("complete");
					moveFile(filename, PROCESSED_DIRECTORY);
				} catch (Exception e) {
					moveFile(filename, ERROR_DIRECTORY);
					System.err.println("Failed to process file " + filename);
					System.err.println(e);
				}
			}
		}
	}

	private static void moveFile(String currentFileName, String newDirectoryName) {
		File currentFile = new File(currentFileName);
		String newFileName = currentFile.getName() + UUID.randomUUID();
		File newFile = new File(newDirectoryName, newFileName);

		File newDirectory = new File(newDirectoryName);
		newDirectory.mkdirs();

		if (currentFile.renameTo(newFile))
			currentFile.delete();
	}
}
