package com.agilex.healthcare.tp;

import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

import com.targetprocess.ArrayOfCommentDTO;
import com.targetprocess.CommentDTO;
import com.targetprocess.UserStoryDTO;
import com.targetprocess.UserStoryService;
import com.targetprocess.UserStoryServiceSoap;


public class UserStoryTest {

	private UserStoryServiceSoap port;
	int userStoryID = 31993;

	@Before
	public void setup(){
		
		UserStoryService service = new UserStoryService();
		port = service.getUserStoryServiceSoap();
		WSS4JUtil securityUtil = new WSS4JUtil();
		securityUtil.addHandlers(port);
		
	}
	
	@Test
	public void validateUserStoryDetailsCanbeRetrieved(){
		UserStoryDTO userStoryDTO = port.getByID(userStoryID);
		
		assertNotNull(userStoryDTO);
		System.out.println(userStoryDTO.getDescription());
	}
	
	@Test 
	public void addCommentToUserStory(){
		CommentDTO commentDTO = new CommentDTO();
		commentDTO.setDescription("Updated from Unit test by Visu");
		port.addCommentToUserStory(userStoryID, commentDTO);
		ArrayOfCommentDTO commentsForUserStory = port.retrieveCommentsForUserStory(userStoryID );
		assertNotNull(commentsForUserStory);
		
		boolean isCommentAdded = false;
		
		for ( CommentDTO comment : commentsForUserStory.getCommentDTO()) {
			if (comment.getDescription().contains("Updated from Unit test by Visu")){
				isCommentAdded = true;
				port.removeCommentFromUserStory(userStoryID, comment.getCommentID());
			}
		}
		
		assertTrue(isCommentAdded);
	}
	
	@Ignore
	public void updateUserStoryStatus(){
		port.changeState(userStoryID, 155);
	}

}
