package com.agilex.healthcare.tp.restservice;

import java.io.ByteArrayOutputStream;
import java.io.IOException;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

import com.agilex.healthcare.tp.WSS4JUtil;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import com.targetprocess.UserStoryDTO;
import com.targetprocess.UserStoryService;
import com.targetprocess.UserStoryServiceSoap;

@Path("/userstory")
public class UserStoryResource {
	
	@Context
	protected UriInfo uriInfo;
	
	@GET
	@Path("{id}")
	@Produces({"text/plain"})
	public String retrieveUserStory(@PathParam("id") int userStoryId){
		UserStoryService service = new UserStoryService();
		UserStoryServiceSoap port = service.getUserStoryServiceSoap();
		WSS4JUtil securityUtil = new WSS4JUtil();
		securityUtil.addHandlers(port);
		UserStoryDTO userStoryDTO = port.getByID(userStoryId);
		String response = "User story does not exist";
		if (userStoryDTO != null){
			response = userStoryDTO.getDescription();
		}
		
		return response;
	}
	
	@GET
	@Path("{id}/barcode")
	@Produces({"image/*"})
	public Response retrieveBarCode(@PathParam("id") int userStoryId){

		QRCodeWriter writer = new QRCodeWriter();
		BitMatrix bitMatrix;
		try {
			bitMatrix = writer.encode("http://www.yahoo.com/", BarcodeFormat.QR_CODE, 100, 100);
		} catch (WriterException e1) {
			throw new RuntimeException(e1);
		}

		ByteArrayOutputStream bos = new ByteArrayOutputStream();

		try {
			MatrixToImageWriter.writeToStream(bitMatrix, "png", bos);
		} catch (IOException e) {
			throw new RuntimeException(e);
		}
		
	    return Response.ok(bos.toByteArray(), "application/octet-stream").build();
	}
	
}
