package com.agilex.healthcare.tp;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class ConfigHelper {
	
	  private String fileName = "tpcredentials.properties";

	  Properties userprops = null;
	  
	  public ConfigHelper() {
		  userprops = getPropertiesFromClasspath(fileName);	 
	  }
	  
	  public String getUserName(){
		  return userprops.getProperty("username");
	  }
	  
	  public String getUserPassword(){
		  return userprops.getProperty("password");
	  }
	  
	  
	  public Properties getPropertiesFromClasspath(String propFileName){
		  	
	        Properties props = new Properties();
	        if (propFileName == null){
	        	propFileName = fileName;
	        }
	        
	        InputStream inputStream = this.getClass().getClassLoader()
	            .getResourceAsStream(propFileName);

	        if (inputStream == null) {
	            throw new RuntimeException("property file '" + propFileName
	                + "' not found in the classpath");
	        }

	        try {
				props.load(inputStream);
			} catch (IOException e) {
				throw new RuntimeException(e);
			}

	        return props;
	    }

}
