package com.agilex.soap;

import org.junit.*;

import javax.xml.soap.SOAPMessage;

import static org.junit.Assert.*;
import static org.mockito.Mockito.*;

public class MessageTest {
    private Message request;

    @Before
    public void setup() {
        request = new Message();
    }

    @Test
    public void removeHeaderTwiceNoException() {
        request.removeHeader()
               .removeHeader();
    }

    @Test
    public void getBody() {
        Body body = request.getBody();

        assertNotNull(body);
    }

    @Test
    public void sendMessage() {
        Service service = mock(Service.class);
        SOAPMessage soapMessage = mock(SOAPMessage.class);
        when(service.send(soapMessage)).thenReturn(soapMessage);

        Message response = request.send(service);

        verify(service).send(any(SOAPMessage.class));
        assertNotNull(response);
    }

    @Test
    public void deserializeMessage() {
        Body body = request.getBody();
        Element bodyElement = body.addChild("TestRoot", "ns2", "http://vaww.oed.oit.domain");

        bodyElement.addChildWithAttributes("id", new String[] {"root", "extension"}, new String[]{"1234", "56789"});
        bodyElement.addChildWithAttribute("processingCode", "code", "T");
        bodyElement.addChildWithAttribute("processingModeCode", "code", "T");
        bodyElement.addChildWithAttribute("acceptAckCode", "code", "AL");

        String msgText = request.toString();

        Message newMessage = new Message(msgText);

        assertEquals("1234", newMessage.getBody().getRootElement().getChild("id", null, null).getAttributeValue("root"));
        assertEquals("T", newMessage.getBody().getRootElement().getChild("processingCode", null, null).getAttributeValue("code"));
        assertEquals(msgText , newMessage.toString());
    }
}
