package com.agilex.soap;

import com.agilex.soap.exceptions.SoapMessageException;
import org.junit.*;
import org.junit.rules.ExpectedException;

public class MessageExceptionTest {

    private Message message;

    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Before
    public void setup() {
        message = new Message("");
    }

    @Test
    public void getSoapBody() {
        thrown.expect(SoapMessageException.class);
        thrown.expectMessage("Unable to get SOAP body from message.");

        message.getBody();
    }

    @Test
    public void removeHeader() {
        thrown.expect(SoapMessageException.class);
        thrown.expectMessage("Unable to get SOAP header.");

        message.removeHeader();
    }
}
