package com.agilex.soap;

import org.junit.*;
import javax.xml.soap.*;

import static org.mockito.Mockito.*;

public class ElementAddTest {
    private static final String LOCAL_NAME = "local";
    private static final String PREFIX = "pre";
    public static final String TEXT = "text";

    private Element element;
    private SOAPElement soapElement;

    @Before
    public void setup() {
        soapElement = mock(SOAPElement.class);
        element = new Element(soapElement);
    }

    @Test
    public void addNamespaceLocalOnly() throws SOAPException {
        element.addNamespace(LOCAL_NAME);

        verify(soapElement).addNamespaceDeclaration("", LOCAL_NAME);
    }

    @Test
    public void addNamespace() throws SOAPException {
        element.addNamespace(PREFIX, LOCAL_NAME);

        verify(soapElement).addNamespaceDeclaration(PREFIX, LOCAL_NAME);
    }

    @Test
    public void addValue() throws SOAPException {
        element.addElementValue(TEXT);

        verify(soapElement).addTextNode(TEXT);
    }
}
