package com.agilex.soap;

import com.agilex.soap.exceptions.SoapMessageException;
import org.junit.*;
import org.junit.rules.ExpectedException;

import javax.xml.soap.SOAPException;

public class ElementAddExceptionTest {
    public static final String LOCAL_NAME = "local";
    public static final String PREFIX = "pre";
    public static final String TEXT = "text";

    private Element element;

    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Before
    public void setup() {
        element = new Element(null);
    }

    @Test
    public void addNamespace() throws SOAPException {
        thrown.expect(SoapMessageException.class);
        thrown.expectMessage("Unable to add namespace to element.");

        element.addNamespace(PREFIX, LOCAL_NAME);
    }

    @Test
    public void addValue() throws SOAPException {
        thrown.expect(SoapMessageException.class);
        thrown.expectMessage("Unable to add text to element.");

        element.addElementValue(TEXT);
    }
}
