package com.agilex.soap;

import com.agilex.soap.exceptions.SoapMessageException;
import org.junit.*;
import org.junit.rules.ExpectedException;

public class ElementAddChildExceptionTest {
    public static final String LOCAL_NAME = "local";
    public static final String PREFIX = "pre";
    public static final String NAMESPACE = "ns";

    private Element element;

    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Before
    public void setup() {
        element = new Element(null);
    }

    @Test
    public void addChildLocalNameOnly() {
        thrown.expect(SoapMessageException.class);
        thrown.expectMessage("Unable to create a child SOAP element.");

        element.addChild(LOCAL_NAME);
    }

    @Test
    public void addChild() {
        thrown.expect(SoapMessageException.class);
        thrown.expectMessage("Unable to create a child SOAP element.");

        element.addChild(LOCAL_NAME, PREFIX, NAMESPACE);
    }
}
