package com.agilex.soap;

import org.junit.*;
import javax.xml.soap.*;
import static junit.framework.Assert.*;

public class BodyTest {

    private SOAPBody soapBody;
    private Body body;

    @Before
    public void setup() throws SOAPException {
        SOAPMessage message = MessageFactory.newInstance().createMessage();
        soapBody = message.getSOAPBody();
        soapBody.addChildElement(Factory.createName("RootElement"));

        body = new Body(soapBody);
    }

    @Test
    public void getRoot() throws SOAPException {
        Body body = new Body(soapBody);

        Element element = body.getRootElement();
        assertNotNull(element);
    }

    @Test(expected = IllegalArgumentException.class)
    public void getRootException() throws SOAPException {
        soapBody.addChildElement(Factory.createName("SecondRootElement"));

        body.getRootElement();
    }
}
