package com.agilex.soap;

import javax.xml.soap.*;

/**
 * Adapter for Java's SOAPHeader class.
 */
public class Header extends Element {
	private final SOAPHeader header;
    private final MimeHeaders mimeHeaders;

	public Header(SOAPHeader header, MimeHeaders mimeHeaders) {
		super(header);
		this.header = header;
        this.mimeHeaders = mimeHeaders;
	}

    public void addMimeHeader(String name, String value) {
        mimeHeaders.addHeader(name, value);
    }
}
