package com.agilex.soap;

import com.agilex.soap.exceptions.SoapMessageException;

import javax.xml.soap.*;

public class Factory {
    private static final org.apache.commons.logging.Log logger = org.apache.commons.logging.LogFactory.getLog(Factory.class);

    //Create a ThreadLocal instance because SOAPFactory does not appear to be thread safe.
    private static class ThreadLocalSOAPFactory extends ThreadLocal<SOAPFactory> {
         public SOAPFactory initialValue() {
            try {
                return SOAPFactory.newInstance();
            } catch (SOAPException e) {
                logger.error("Unable to create SOAP Factory.", e);
                throw new SoapMessageException("Unable to create SOAP Factory.", e);
            }
        }
    }

    private static ThreadLocalSOAPFactory factory = new ThreadLocalSOAPFactory();

    public static Name createName(String name) {
        try {
            return factory.get().createName(name);
        } catch (Throwable t) {
            throw new SoapMessageException("Soap factory was unable to create name.", t);
        }
    }

    public static Name createName(String name, String prefix, String namespace) {
        try {
            return factory.get().createName(name, prefix, namespace);
        } catch (Throwable t) {
            throw new SoapMessageException("Soap factory was unable to create name.", t);
        }
    }
}
