package com.agilex.soap;

import com.google.common.collect.Lists;

import javax.xml.soap.SOAPElement;
import java.util.*;

/**
 * This class represents a collection of Elements.
 */
public class Elements {
    private final Iterator iterator;

    public Elements(Iterator iterator) {
        this.iterator = iterator;
    }

    /**
     * Gets the attribute value for a collection of Elements.
     *
     * @param attribute - the attribute to find in each Element in the collection
     * @return List<String> - the value for a specific attribute for each Element in the collection of Elements
     */
    public List<String> getAttributeValue(String attribute) {
        ArrayList<String> values = Lists.newArrayList();

        while (iterator.hasNext()) {
            SOAPElement element = (SOAPElement) iterator.next();
            values.add(element.getAttributeValue(Factory.createName(attribute)));
        }

        return values;
    }
}
