package com.agilex.soap;

import com.google.common.collect.Iterators;

import javax.xml.soap.*;

/**
 * Adapter for Java's SOAPBody class.
 */
public class Body extends Element {
    private final SOAPBody body;

    public Body(SOAPBody body) {
        super(body);
        this.body = body;
    }

    /**
     * SOAP messages typically have a single element in the SOAP body.  This method will return
     * that element.
     *
     * @return Element - single root element in SOAP message body
     * @throws IllegalArgumentException - if the SOAP message contains multiple elements
     */
    public Element getRootElement() {
        SOAPElement element = (SOAPElement) Iterators.getOnlyElement(body.getChildElements());

        return new Element(element);
    }

    public boolean hasFault() {
        return body.hasFault();
    }

    public Fault getFault() {
        return new Fault(body.getFault());
    }
}
