package com.agilex.healthcare.testutility;

import java.net.URI;
import java.util.UUID;

import com.agilex.healthcare.mobilehealthplatform.client.AuthenticationInfo;
import com.agilex.healthcare.mobilehealthplatform.clientapi.MobileHealthClientTestVersion;
import com.agilex.healthcare.mobilehealthplatform.domain.Documents;
import com.agilex.healthcare.mobilehealthplatform.domain.Patient;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.Patients;
import com.sun.jersey.api.client.Client;

public class TestHelper {
	private static MobileHealthClientTestVersion client = createMobileHealthClient();

	public static MobileHealthClientTestVersion createMobileHealthClient() {
		AuthenticationInfo authenticationInfo = IntegrationTestConfiguration.getAuthenticationInformation();
		return createMobileHealthClient(authenticationInfo);
	}
	
	public static MobileHealthClientTestVersion createProviderMobileHealthClient() {
		AuthenticationInfo authenticationInfo = IntegrationTestConfiguration.getProviderAuthenticationInformation();
		return createMobileHealthClient(authenticationInfo);
	}

	public static Client createJerseyClient() {
		return createMobileHealthClient().getJerseyClient();
	}
	
	public static MobileHealthClientTestVersion createMobileHealthClient(String username, String password, String authType) {
		AuthenticationInfo authenticationInfo = new AuthenticationInfo(username, password, authType);
		
		return createMobileHealthClient(authenticationInfo);
	}
	
	public static MobileHealthClientTestVersion createMobileHealthClient(AuthenticationInfo authenticationInfo) {
		String uri = IntegrationTestConfiguration.getMobileHealthServerBaseUri();
		MobileHealthClientTestVersion mobileHealthClient = new MobileHealthClientTestVersion(uri, authenticationInfo);
		return mobileHealthClient;
	}

	public static Patient getTestPatientViaDirectRetrieve() {
		Patient searchResultPatient = PatientLoader.loadTestPatient();
		Patient patient = client.getPatientResourceClient().getPatient(searchResultPatient);
		return patient;
	}

    public static Patient getProviderTestPatientViaDirectRetrieve() {
        Patient searchResultPatient = PatientLoader.loadProviderTestPatient();
        Patient patient = client.getPatientResourceClient().getPatient(searchResultPatient);
        return patient;
    }
    
	public static Patients getTestPatientSearchResults() {
		String lastname = IntegrationTestConfiguration.getTestPatient().getLastName();
		String firstname = IntegrationTestConfiguration.getTestPatient().getFirstName();
		Patient prototype = new Patient();
		prototype.setLastName(lastname);
		prototype.setFirstName(firstname);

		Patients patients = client.getPatientResourceClient().patientSearch(prototype);

		return patients;
	}

	public static com.agilex.healthcare.mobilehealthplatform.domain.Document getTestDocument() {
		Patient patient = PatientLoader.loadTestPatient();
		Documents documents = client.getPatientResourceClient().getPatientDocuments(patient);
		com.agilex.healthcare.mobilehealthplatform.domain.Document document = documents.get(0);
		return document;
	}

	public static boolean beginsWith(String value, String compareTo) {
		int length = compareTo.length();
		String beginning = value.substring(0, length);
		return beginning.toLowerCase().contentEquals(compareTo.toLowerCase());
	}

	public static PatientIdentifier generateRandomPatientIdentifierInMockAssigningAuthority() {
		return generateRandomPatientIdentifier("EDIPI");
	}

	public static PatientIdentifier generateRandomPatientIdentifier(String assigningAuthority) {
		return new PatientIdentifier(assigningAuthority, UUID.randomUUID().toString());
	}

	public static URI getPatientDataUri(PatientIdentifier patientIdentifier, String linkTitle, String userName) {
		Patient patient = PatientLoader.loadPatient(patientIdentifier, userName);
		return patient.getLink().getUriByTitle(linkTitle);
	}

}
