package com.agilex.healthcare.testutility;

import static org.junit.Assert.assertNotNull;

import java.net.URI;

import javax.ws.rs.core.UriBuilder;

import com.agilex.healthcare.mobilehealthplatform.domain.ResourceDirectory;
import com.sun.jersey.api.client.Client;

public class ResourceDirectoryLoader {
	private static final org.apache.commons.logging.Log logger = org.apache.commons.logging.LogFactory.getLog(ResourceDirectoryLoader.class);

	public static ResourceDirectory loadResourceDirectory() {
		URI resourceDirectoryUri = UriBuilder.fromPath(IntegrationTestConfiguration.getMobileHealthServerBaseUri()).path("public").path("resource-directory").build();

		logger.debug("loading resource directory using url " + resourceDirectoryUri);

		Client jerseyClient = new Client();
		ResourceDirectory resourceDirectory = jerseyClient.resource(getResourceDirectoryURI()).accept("application/xml").get(ResourceDirectory.class);
		jerseyClient.destroy();
		assertNotNull("failed to retrieve resource directory", resourceDirectory);
		return resourceDirectory;
	}
	
	private static URI getResourceDirectoryURI() {
		return IntegrationTestConfiguration.getHealthAdapterResourceDirectoryUri();
	}
}
