package com.agilex.healthcare.testutility;

import static org.junit.Assert.assertNotNull;

import java.net.URI;

import javax.ws.rs.core.UriBuilder;

import org.w3c.dom.Document;

import com.agilex.healthcare.mobilehealthplatform.client.AuthenticationInfo;
import com.agilex.healthcare.mobilehealthplatform.clientapi.MobileHealthClientTestVersion;
import com.agilex.healthcare.mobilehealthplatform.domain.Patient;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;

public class PatientLoader {
	private static final org.apache.commons.logging.Log logger = org.apache.commons.logging.LogFactory.getLog(PatientLoader.class);

	public static Patient loadPatient(PatientIdentifier patientIdentifier, String userName, String password, String authType) {
		URI patientUri = UriBuilder.fromPath(IntegrationTestConfiguration.getMobileHealthServerBaseUri()).path("patient").path(patientIdentifier.getAssigningAuthority()).path(patientIdentifier.getUniqueId()).build();
		logger.debug("loading patient using url " + patientUri);

		MobileHealthClientTestVersion client = TestHelper.createMobileHealthClient(userName, password, authType);
		Patient patient = client.getJerseyClient().resource(patientUri).get(Patient.class);
		assertNotNull("failed to retrieve patient [id=" + patientIdentifier + "]", patient);
		return patient;
	}

    public static Patient loadPatient(PatientIdentifier patientIdentifier) {
        URI patientUri = UriBuilder.fromPath(IntegrationTestConfiguration.getMobileHealthServerBaseUri()).path("patient").path(patientIdentifier.getAssigningAuthority()).path(patientIdentifier.getUniqueId()).build();
        logger.debug("loading patient using url " + patientUri);

        MobileHealthClientTestVersion client = TestHelper.createProviderMobileHealthClient();//createMobileHealthClient(userName, password, authType);
        Patient patient = client.getJerseyClient().resource(patientUri).get(Patient.class);
        assertNotNull("failed to retrieve patient [id=" + patientIdentifier + "]", patient);
        return patient;
    }
    
	public static Patient loadPatient(PatientIdentifier patientIdentifier, String userName) {
		return loadPatient(patientIdentifier, userName, "pass", "oauth");
	}
	
	public static Document loadPatientAsXml(PatientIdentifier patientIdentifier, String userName, String password, String authType) {
		URI patientUri = UriBuilder.fromPath(IntegrationTestConfiguration.getMobileHealthServerBaseUri()).path("patient").path(patientIdentifier.getAssigningAuthority()).path(patientIdentifier.getUniqueId()).build();
		logger.debug("loading patient using url " + patientUri);

		MobileHealthClientTestVersion client = TestHelper.createMobileHealthClient(userName, password, authType);
		Document patient = client.getJerseyClient().resource(patientUri).get(Document.class);
		assertNotNull("failed to retrieve patient [id=" + patientIdentifier + "]", patient);
		return patient;
	}

	public static Patient loadTestPatient() {
		return loadPatient(IntegrationTestConfiguration.getTestPatient(), "zztest.patient01");
	}

    public static Patient loadProviderTestPatient() {
        return loadProviderPatient(IntegrationTestConfiguration.getTestPatient());
    }
    
	public static Patient loadTestLabPatient() {
		return loadPatient(IntegrationTestConfiguration.getLabPatient(), "zztest.patient01");
	}

	public static Patient loadTestLabPatientWithGroups() {
		return loadPatient(IntegrationTestConfiguration.getLabPatientWithGroups(), "zztest.patient01");
	}

	public static Patient loadTestMedPatient() {
		return loadPatient(IntegrationTestConfiguration.getMedPatient(), "zztest.patient01");
	}

	public static Patient loadTestPatientForInpatientMed() {
		return loadPatient(IntegrationTestConfiguration.getPatientForInpatientMed(), "zztest.patient01");
	}

	public static Patient loadTestPatientWithNoData() {
		return loadPatient(IntegrationTestConfiguration.getTestPatientWithNoData(), "patient.healthy");
	}

	private static Patient loadPatient(Patient patient, String userName) {
		return loadPatient(patient.getPatientIdentifier(), userName);
	}

    private static Patient loadProviderPatient(Patient patient) {
        if(patient.getPatientIdentifier().getAssigningAuthority() == null)
            patient.getPatientIdentifier().setAssigningAuthority("EDIPI");
        return loadPatient(patient.getPatientIdentifier());
    }
    
	public static Patient loadPatientAsProvider(PatientIdentifier patientIdentifier, String userName) {
		URI patientUri = UriBuilder.fromPath(IntegrationTestConfiguration.getMobileHealthServerBaseUri()).path("patient").path(patientIdentifier.getAssigningAuthority()).path(patientIdentifier.getUniqueId()).build();
		logger.debug("loading patient using url " + patientUri);
		AuthenticationInfo authInfo = new AuthenticationInfo();
		authInfo.setUsername(userName);
		authInfo.setPassword("pass");
		authInfo.setAuthtype("oauth");
		authInfo.setFacilityCode("688");
		authInfo.setFacilityName("DC VAMC");
			
		MobileHealthClientTestVersion client = TestHelper.createMobileHealthClient(authInfo);
		Patient patient = client.getJerseyClient().resource(patientUri).get(Patient.class);
		assertNotNull("failed to retrieve patient [id=" + patientIdentifier + "]", patient);
		return patient;
	}

}
