package com.agilex.healthcare.testutility;

import static org.junit.Assert.fail;

import java.net.URI;
import java.util.GregorianCalendar;
import java.util.List;

import com.agilex.healthcare.utility.NullChecker;

public class NullCheckerAssert {

	public static void assertNotNullish(String value) {
		if (NullChecker.isNullish(value))
			fail();
	}

	public static void assertNotNullish(String message, String value) {
		if (NullChecker.isNullish(value))
			fail(message);
	}

	public static void assertNotNullish(List<?> value) {
		if (NullChecker.isNullish(value))
			fail();
	}

	public static void assertNotNullish(String message, List<?> value) {
		if (NullChecker.isNullish(value))
			fail(message);
	}

	public static void assertNotNullish(GregorianCalendar value) {
		if (NullChecker.isNullish(value))
			fail();
	}

	public static void assertNotNullish(String message, GregorianCalendar value) {
		if (NullChecker.isNullish(value))
			fail(message);
	}

	public static void assertNotNullish(URI value) {
		if (NullChecker.isNullish(value))
			fail();
	}

	public static void assertNotNullish(String message, URI value) {
		if (NullChecker.isNullish(value))
			fail(message);
	}

}
