package com.agilex.healthcare.testutility;

import static org.junit.Assert.assertTrue;

import java.net.URI;

import org.springframework.http.MediaType;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import com.agilex.healthcare.mobilehealthplatform.domain.Patient;
import com.agilex.healthcare.utility.NullChecker;
import com.agilex.healthcare.utility.XpathHelper;
import com.sun.jersey.api.client.Client;

public class LinkTestRunner {
	public static void validateLinksForPatientDataObject(String linkTitle, String xpathToDataElement, boolean expectDataToHaveSelfLink) {
		Client client = TestHelper.createMobileHealthClient().getJerseyClient();
		Patient testPatient = PatientLoader.loadTestPatient();

		URI linkToPatientData = testPatient.getLink().getUriByTitle(linkTitle);
		validateUri(linkToPatientData);

		System.out.println("linkToPatientData:" + linkToPatientData);
		Document dataCollection = client.resource(linkToPatientData).accept(MediaType.APPLICATION_XML.toString()).get(Document.class);
		NodeList dataNodeList = XpathHelper.getNodeList(dataCollection, xpathToDataElement);
		assertTrue(dataNodeList.getLength() > 0);

		if (expectDataToHaveSelfLink) {
			for (int i = 0; i < dataNodeList.getLength(); i++) {
				Node dataNode = dataNodeList.item(i);
				URI selfUri = XpathHelper.getUri(dataNode, "atom:link[@rel='self']/@href");
				validateUri(selfUri);

				//FIXME: remove this comments after fixing the data system in mock data
//				Document data = client.resource(selfUri).accept(MediaType.APPLICATION_XML.toString()).get(Document.class);
//
//				selfUri = XpathHelper.getUri(data, "*/atom:link[@rel='self']/@href");
//				validateUri(selfUri);
			}
		}
		
		client.destroy();
	}

	private static void validateUri(URI linkToPatientData) {
		assertTrue(NullChecker.isNotNullish(linkToPatientData));
	}
}
