package com.agilex.healthcare.testutility;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

import javax.ws.rs.core.UriBuilder;

import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.w3c.dom.Document;

import com.agilex.healthcare.mobilehealthplatform.client.AuthenticationInfo;
import com.agilex.healthcare.mobilehealthplatform.domain.Allergy;
import com.agilex.healthcare.mobilehealthplatform.domain.LabResult;
import com.agilex.healthcare.mobilehealthplatform.domain.Medication;
import com.agilex.healthcare.mobilehealthplatform.domain.Patient;
import com.agilex.healthcare.mobilehealthplatform.domain.Problem;
import com.agilex.healthcare.utility.NullChecker;
import com.agilex.healthcare.utility.XpathHelper;
import com.sun.jersey.api.client.Client;

@SuppressWarnings("unchecked")
public class IntegrationTestConfiguration {

	public static final String CONFIGURATION_FILENAME = "integrationApplicationContext.xml";
	private static Map<String, String> properties = null;
	private static BeanFactory factory;

	static {
		factory = new ClassPathXmlApplicationContext(new String[] { CONFIGURATION_FILENAME });
		properties = (Map<String, String>) factory.getBean("configProperties");
	}

	public static Patient getPatient(String patientKey) {
		return (Patient) factory.getBean(patientKey);
	}

	public static Patient getTestPatient() {
		return getPatient("patientYounger");
	}

	public static Patient getTestInpatient() {
		return getPatient("testInpatient");
	}

	public static Patient getPatient     WithSSN() {
		return getPatient("patient     WithSSN");
	}

	public static Patient getTestPatientWithoutMiddleName() {
		return getPatient("patientWithoutMiddleName");
	}

	public static Patient getTestPatientWithSpaceInName() {
		return getPatient("patientWithSpaceInName");
	}

	public static String getMobileHealthServerBaseUri() {
		return getProperty("MobileHealthPlatformServerURI");
	}

	public static URI getHealthAdapterResourceDirectoryUri() {
		URI resourceDirectory = UriBuilder.fromUri(IntegrationTestConfiguration.getMobileHealthServerBaseUri()).path("public").path("resource-directory").build();
		return resourceDirectory;
	}
	
	public static URI getResourceUri(String resourceTitle) {
		Client jerseyClient = new Client();
		Document resources = jerseyClient.resource(IntegrationTestConfiguration.getHealthAdapterResourceDirectoryUri()).get(Document.class);
		return XpathHelper.getUri(resources, "//item[title='" + resourceTitle +  "']/link");
	}


	public static String getMHPAuthorizeURI() {
		return getProperty("MHPAuthorizeURI");
	}

	public static String getMHPTokenURI() {
		return getProperty("MHPTokenURI");
	}

	public static String getMHBaseURI() {
		return getProperty("MHPBaseURI");
	}

	public static AuthenticationInfo getAuthenticationInformation() {
		AuthenticationInfo authenticationInfo = null;
		if (NullChecker.isNotNullish(getAuthType())) {
			authenticationInfo = new AuthenticationInfo();
			authenticationInfo.setUsername(getUsername());
			authenticationInfo.setPassword(getPassword());
			authenticationInfo.setAuthtype(getAuthType());
			authenticationInfo.setFacilityName(getFacilityName());
			authenticationInfo.setFacilityCode(getFacilityCode());
		}
		return authenticationInfo;
	}

	public static AuthenticationInfo getProviderAuthenticationInformation() {
		AuthenticationInfo authenticationInfo = null;
		if (NullChecker.isNotNullish(getAuthType())) {
			authenticationInfo = new AuthenticationInfo();
			authenticationInfo.setUsername("zztest.staff01");
			authenticationInfo.setPassword("pass");
			authenticationInfo.setAuthtype(getAuthType());
			authenticationInfo.setFacilityName("DC VAMC");
			authenticationInfo.setFacilityCode("688");
		}
		return authenticationInfo;
	}

	private static String getUsername() {
		return getProperty("username");
	}

	private static String getPassword() {
		return getProperty("password");
	}

	private static String getAuthType() {
		String authtype = getProperty("authtype");
		return authtype;
	}

	private static String getFacilityName() {
		String authtype = getProperty("facilityName");
		return authtype;
	}
	
	private static String getFacilityCode() {
		String authtype = getProperty("facilityCode");
		return authtype;
	}
	
	private static String getProperty(String key) {
		return properties.get(key);
	}

	public static Patient getTestPatientWithNoData() {
		return getPatient("patientHealthy");
	}

	public static Allergy getTestAllergy() {
		return (Allergy) factory.getBean("testAllergy");
	}

	public static Patient getMedPatient() {
		return getPatient("patientMed");
	}

	public static Medication getOutpatientMedication() {
		return (Medication) factory.getBean("patientMed.outpatientMed");
	}

	public static Medication getInpatientMedication() {
		return (Medication) factory.getBean("patientMed.inpatientMed");
	}

	public static Patient getLabPatient() {
		return getPatient("patientLab");
	}

	public static Patient getLabPatientWithGroups() {
		return getPatient("patientLabWithGroups");
	}

	public static LabResult getLabPatientTestLab1() {
		return (LabResult) factory.getBean("patientLab.testLab1-recent");
	}

	public static LabResult getLabPatientTestLab2() {
		return (LabResult) factory.getBean("patientLab.testLab2-recent");
	}

	public static LabResult getLabPatientTestLabAbnormal() {
		return (LabResult) factory.getBean("patientLab.testLabAbnormal");
	}

	public static LabResult getLabPatientTestLabNormal() {
		return (LabResult) factory.getBean("patientLab.testLabNormal");
	}

	public static LabResult getLabResultStandardReferenceRange() {
		return (LabResult) factory.getBean("patientLab.testLabNormal");
	}

	public static LabResult getLabResultLessThanUpperReferenceRange() {
		return (LabResult) factory.getBean("patientLab.testLabLessThanUpperReferenceRange");
	}

	public static Patient getFirst     Patient() {
		return getPatient("patientFirst     ");
	}

	public static Patient getPatientWithValidDOB() {
		return getPatient("patientWithValidDOB");
	}

	public static Patient getPatientWithDOBMonthYear() {
		return getPatient("patientWithDOBMonthYear");
	}

	public static Patient getPatientWithDOBYear() {
		return getPatient("patientWithDOBYear");
	}

	public static HashMap<String, String> getAppointmentData() {
		return factory.getBean("expectedAppointmentData", HashMap.class);
	}

	public static Set<String> getExpectedGroupsOrderForPateintId() {
		return factory.getBean("expectedGroupsOrderForPatteintId", Set.class);
	}

	public static Set<String> getExpectedLabTestIdsOrderForCBCProfileGroup() {
		return factory.getBean("expectedLabTestIdsInCBCProfileGroup", Set.class);
	}

	public static Problem getProblem() {
		return factory.getBean("testProblem", Problem.class);
	}

	public static Patient getPatientForInpatientMed() {
		return getPatient("testPatientInpatientMed");
	}

}
