package com.agilex.healthcare.mobilehealthplatform.restservice.vitals;

import static org.junit.Assert.assertNotNull;

import java.net.URI;

import javax.ws.rs.core.UriBuilder;

import org.junit.AfterClass;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.clientapi.MobileHealthClientTestVersion;
import com.agilex.healthcare.mobilehealthplatform.domain.LinkTitles;
import com.agilex.healthcare.mobilehealthplatform.domain.Patient;
import com.agilex.healthcare.mobilehealthplatform.domain.VitalTableData;
import com.agilex.healthcare.testutility.PatientLoader;
import com.agilex.healthcare.testutility.TestHelper;
import com.agilex.healthcare.utility.ModeHelper;

public class PatientEnteredVitalTableTest {

	private static MobileHealthClientTestVersion client;
	
	@BeforeClass
	public static void checkWhetherTestsAreRunningInCIHMode() {
		Assume.assumeTrue(ModeHelper.isMode("va-veteran-dev", "dev"));
		client = TestHelper.createMobileHealthClient();
	}

	@AfterClass
	public static void destroy() {
		if (client != null) {
			client.getJerseyClient().destroy();
			client = null;
		}
	}
	

	@Test
	public void ableToRetrieveTableWithoutError() {
		Patient patient = getTestPatient();
		URI uri = patient.getLink().getUriByTitle(LinkTitles.PatientEnteredVitalsTableData);
		assertNotNull(uri);
		uri = UriBuilder.fromUri(uri).queryParam("section", "BP").build();
		 VitalTableData vitalTableData = client.getJerseyClient().resource(uri).get(VitalTableData.class);
		assertNotNull(vitalTableData);
	}

	private Patient getTestPatient() {
		Patient patient = PatientLoader.loadTestPatient();
		return patient;
	}
}
