package com.agilex.healthcare.mobilehealthplatform.restservice.vitals;

import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.fail;

import java.net.URI;

import javax.ws.rs.core.UriBuilder;

import org.junit.AfterClass;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.clientapi.MobileHealthClientTestVersion;
import com.agilex.healthcare.mobilehealthplatform.domain.GraphData;
import com.agilex.healthcare.mobilehealthplatform.domain.LinkTitles;
import com.agilex.healthcare.mobilehealthplatform.domain.Patient;
import com.agilex.healthcare.testutility.PatientLoader;
import com.agilex.healthcare.testutility.TestHelper;
import com.agilex.healthcare.utility.ModeHelper;
import com.sun.jersey.api.client.UniformInterfaceException;

public class PatientEnteredVitalGraphTest {

	private static MobileHealthClientTestVersion client;
	
	@BeforeClass
	public static void checkWhetherTestsAreRunningInCIHMode() {
		Assume.assumeTrue(ModeHelper.isMode("va-veteran-dev"));
		client = TestHelper.createMobileHealthClient();
	}

	@AfterClass
	public static void destroy() {
		if (client != null) {
			client.getJerseyClient().destroy();
			client = null;
		}
	}
	
	@Test
	public void ableToRetrieveGraphWithoutError() {
		Patient patient = getTestPatient();
		URI uri = patient.getLink().getUriByTitle(LinkTitles.PatientEnteredVitalsGraphData);
		assertNotNull(uri);
		uri = UriBuilder.fromUri(uri).queryParam("section", "BP").build();
		GraphData graphData = client.getJerseyClient().resource(uri).get(GraphData.class);
		assertNotNull(graphData);
	}

	@Test(expected = UniformInterfaceException.class)
	public void retrieveWithoutSectionReturnsError() {
		Patient patient = getTestPatient();
		URI uri = patient.getLink().getUriByTitle(LinkTitles.PatientEnteredVitalsGraphData);
		client.getJerseyClient().resource(uri).get(GraphData.class);
		fail("should have errored before reaching here");
	}

	private Patient getTestPatient() {
		Patient patient = PatientLoader.loadTestPatient();
		return patient;
	}
}
