package com.agilex.healthcare.mobilehealthplatform.restservice.surgery;

import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

import java.net.URI;
import java.util.Date;

import javax.ws.rs.core.UriBuilder;

import org.junit.AfterClass;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.clientapi.MobileHealthClientTestVersion;
import com.agilex.healthcare.mobilehealthplatform.domain.LinkTitles;
import com.agilex.healthcare.mobilehealthplatform.domain.Patient;
import com.agilex.healthcare.mobilehealthplatform.domain.Surgeries;
import com.agilex.healthcare.mobilehealthplatform.domain.Surgery;
import com.agilex.healthcare.testutility.PatientLoader;
import com.agilex.healthcare.testutility.TestHelper;
import com.agilex.healthcare.utility.DateHelper;
import com.agilex.healthcare.utility.ModeHelper;

public class SurgeryResourceTest {

	private static MobileHealthClientTestVersion client;
	
	@BeforeClass
	public static void checkWhetherTestsAreRunningInCIHMode() {
		Assume.assumeTrue(ModeHelper.isMode("va-veteran-dev", "dev"));
		client = TestHelper.createMobileHealthClient();
	}

	@AfterClass
	public static void destroy() {
		if (client != null) {
			client.getJerseyClient().destroy();
			client = null;
		}
	}
	
	@Test
	public void getSurgery() {
		Patient patient = PatientLoader.loadTestPatient();
		URI uri = patient.getLink().getUriByTitle(LinkTitles.PatientSurgeries);

		Surgeries surgeries = client.getJerseyClient().resource(uri).get(Surgeries.class);
		assertTrue(surgeries.size() > 0);
	}
	
	@Test
	public void verifySortOrder() {
		Patient patient = PatientLoader.loadTestPatient();
		URI uri = patient.getLink().getUriByTitle(LinkTitles.PatientSurgeries);

		Surgeries surgeries = client.getJerseyClient().resource(uri).get(Surgeries.class);
		
		assertNotNull(surgeries);
		
		Date surgery1 = null;
		Date surgery2 = null;
		
		for(int i = 0; i < surgeries.getSize() - 1; i++)
		{
			surgery1 = surgeries.get(i).getDate();
			surgery2 = surgeries.get(i + 1).getDate();
			
			assertTrue(surgery1.after(surgery2) || surgery1.equals(surgery2));
		}
	}
	
	@Ignore
	public void getSurgeryByEntryDate() {
		Patient patient = PatientLoader.loadTestPatient();
		URI uri = patient.getLink().getUriByTitle(LinkTitles.PatientSurgeries);
		uri = UriBuilder.fromUri(uri).queryParam("entrydate", "10/3/2009").build();

		Surgeries surgeries = client.getJerseyClient().resource(uri).get(Surgeries.class);
		assertTrue(surgeries.size() > 0);
		for (Surgery surgery : surgeries) {
			System.out.println(surgery.getProcedureDate()) ;
			assertTrue("Date failed test "+ surgery.getProcedureDate(),surgery.getProcedureDate().compareTo(DateHelper.parseDate("10/3/2009")) >= 0);
			assertTrue("Date failed test "+ surgery.getProcedureDate(),surgery.getProcedureDate().compareTo(DateHelper.parseDate("10/4/2009")) <= 0);
		}
	}

}
