package com.agilex.healthcare.mobilehealthplatform.restservice.staffuserdisclaimer;

import static org.junit.Assert.assertTrue;
import static org.junit.Assert.fail;

import java.net.URI;

import javax.ws.rs.core.Response;

import org.junit.AfterClass;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.client.AuthenticationInfo;
import com.agilex.healthcare.mobilehealthplatform.clientapi.MobileHealthClientTestVersion;
import com.agilex.healthcare.mobilehealthplatform.domain.AtomLink;
import com.agilex.healthcare.mobilehealthplatform.domain.AtomLinks;
import com.agilex.healthcare.mobilehealthplatform.domain.LinkTitles;
import com.agilex.healthcare.mobilehealthplatform.domain.MhpUser;
import com.agilex.healthcare.mobilehealthplatform.domain.ResourceDirectory;
import com.agilex.healthcare.mobilehealthplatform.domain.StaffUserDisclaimerContent;
import com.agilex.healthcare.testutility.IntegrationTestConfiguration;
import com.agilex.healthcare.testutility.TestHelper;
import com.agilex.healthcare.utility.ModeHelper;
import com.agilex.healthcare.utility.NullChecker;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.UniformInterfaceException;

public class StaffUserDisclaimerVeteranResourceTest {
	
	private static ResourceDirectory resourceDirectory = null;
	private static MobileHealthClientTestVersion client;
	private static Client jerseyClient;
	private static MhpUser mhpUser = null;
	private static URI StaffUserDisclaimerUri = null;
	
	@BeforeClass
	public static void setUpResourceDirectoryAndUser() {
		Assume.assumeTrue(ModeHelper.isVeteranMode());
		client = TestHelper.createMobileHealthClient();
		jerseyClient = client.getJerseyClient();
		URI resourceDirectoryURI = IntegrationTestConfiguration.getHealthAdapterResourceDirectoryUri();
		resourceDirectory = jerseyClient.resource(resourceDirectoryURI).accept("application/xml").get(ResourceDirectory.class);
		
		URI mhpUserResourceUri = getMhpUserResourceUri();
		
		mhpUser = getMhpUser(mhpUserResourceUri);
		StaffUserDisclaimerUri = getStaffUserDisclaimerURI(mhpUser);
	}
	
	@AfterClass
	public static void destroy() {
		if (jerseyClient != null) {
			jerseyClient.destroy();
			jerseyClient = null;
		}
		client = null;
		jerseyClient = null;
	}
	
	@Test
	public void validateGetLatestStaffUserDisclaimerContent() {
		URI StaffUserDisclaimerContentUri = getStaffUserDisclaimerContentURI(mhpUser);
		StaffUserDisclaimerContent staffUserDisclaimerContent = client.getJerseyClient().resource(StaffUserDisclaimerContentUri).get(StaffUserDisclaimerContent.class);
		staffUserDisclaimerContent.getContent();
		
		assertTrue(NullChecker.isNotNullish(staffUserDisclaimerContent.getDate()));
		assertTrue(NullChecker.isNotNullish(staffUserDisclaimerContent.getContent()));
	}

	@Test
	public void validateErrorIsReturnedIfStaffUserDisclaimerIsNotAvailable(){
		String uri = IntegrationTestConfiguration.getMobileHealthServerBaseUri();
		AuthenticationInfo authenticationInfo = IntegrationTestConfiguration.getAuthenticationInformation();
		authenticationInfo.setUsername("zztest.patient26");
		authenticationInfo.setPassword("pass");
		MobileHealthClientTestVersion mobileHealthClient = new MobileHealthClientTestVersion(uri, authenticationInfo);
		
		boolean error = false;
		try {
			Response response = mobileHealthClient.getJerseyClient().resource(StaffUserDisclaimerUri).get(Response.class);
			System.out.println(response.getStatus());
		} catch (UniformInterfaceException e) {
			error = true;
			if (e.getResponse().getStatus() != 204) {
				fail("Unknown error");
			}
		}
		assertTrue("Error should happen", error);
	}
	
	private static URI getMhpUserResourceUri() {
		URI mhpUserResourceUri = null;
		AtomLinks links = resourceDirectory.getLink();
		mhpUserResourceUri = getUriForTitle(LinkTitles.MHPUser, links);
		return mhpUserResourceUri;
	}

	private static URI getUriForTitle(String title, AtomLinks links) {
		URI targetUri = null;
		for (AtomLink atomLink : links) {
			if(atomLink.getTitle().equals(title)){
				targetUri = atomLink.getHref();
				break;
			}
		}
		
		return targetUri;
	}
	
	private static URI getStaffUserDisclaimerURI(MhpUser mhpUser){
		return getUriForTitle(LinkTitles.StaffUserDisclaimer, mhpUser.getLink());
	}
	
	private static URI getStaffUserDisclaimerContentURI(MhpUser mhpUser){
		return getUriForTitle(LinkTitles.StaffUserDisclaimerContent, mhpUser.getLink());
	}
	
	private static MhpUser getMhpUser(URI mhpUserResourceUri) {
		return client.getJerseyClient().resource(mhpUserResourceUri).get(MhpUser.class);		
	}
		
}